/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.SocketChannelImpl;
import sun.nio.ch.Util;

public class SocketAdaptor
extends Socket {
    private final SocketChannelImpl sc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private InputStream socketInputStream = null;

    private SocketAdaptor(SocketChannelImpl socketChannelImpl) throws SocketException {
        super((SocketImpl)null);
        this.sc = socketChannelImpl;
    }

    public static Socket create(SocketChannelImpl socketChannelImpl) {
        try {
            return new SocketAdaptor(socketChannelImpl);
        }
        catch (SocketException socketException) {
            throw new InternalError("Should not reach here");
        }
    }

    public SocketChannel getChannel() {
        return this.sc;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (n == 0) {
                    this.sc.connect(socketAddress);
                    return;
                }
                SelectionKey selectionKey = null;
                Selector selector = null;
                this.sc.configureBlocking(false);
                try {
                    block21: {
                        long l;
                        if (this.sc.connect(socketAddress)) {
                            Object var13_7 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (this.sc.isOpen()) {
                                this.sc.configureBlocking(true);
                            }
                            if (selector == null) return;
                            Util.releaseTemporarySelector(selector);
                            return;
                        }
                        selector = Util.getTemporarySelector(this.sc);
                        selectionKey = this.sc.register(selector, 8);
                        long l2 = n;
                        do {
                            if (!this.sc.isOpen()) {
                                throw new ClosedChannelException();
                            }
                            l = System.currentTimeMillis();
                            int n2 = selector.select(l2);
                            if (n2 > 0 && selectionKey.isConnectable() && this.sc.finishConnect()) break block21;
                            selector.selectedKeys().remove(selectionKey);
                        } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                        try {
                            this.sc.close();
                            throw new SocketTimeoutException();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw new SocketTimeoutException();
                    }
                    Object var13_8 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (selector == null) return;
                    Util.releaseTemporarySelector(selector);
                }
                catch (Throwable throwable) {
                    Object var13_9 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.sc.isOpen()) {
                        this.sc.configureBlocking(true);
                    }
                    if (selector == null) throw throwable;
                    Util.releaseTemporarySelector(selector);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                Net.translateException(exception, true);
            }
            return;
        }
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public InetAddress getInetAddress() {
        if (!this.sc.isConnected()) {
            return null;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getAddress();
    }

    public InetAddress getLocalAddress() {
        if (!this.sc.isBound()) {
            return new InetSocketAddress(0).getAddress();
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getAddress();
    }

    public int getPort() {
        if (!this.sc.isConnected()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.remoteAddress()).getPort();
    }

    public int getLocalPort() {
        if (!this.sc.isBound()) {
            return 0;
        }
        return Net.asInetSocketAddress(this.sc.localAddress()).getPort();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Channels.newOutputStream(SocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.sc);
        }
        return this.opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTcpNoDelay(boolean bl) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setTcpNoDelay(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTcpNoDelay() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getTcpNoDelay();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoLinger(boolean bl, int n) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setSoLinger(bl, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSoLinger() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getSoLinger();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUrgentData(int n) throws IOException {
        Object object = this.sc.blockingLock();
        synchronized (object) {
            if (!this.sc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            int n2 = this.sc.sendOutOfBandData((byte)n);
            assert (n2 == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOOBInline(boolean bl) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setOOBInline(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOOBInline() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getOOBInline();
        }
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendBufferSize(int n) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setSendBufferSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSendBufferSize() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getSendBufferSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveBufferSize(int n) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setReceiveBufferSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReceiveBufferSize() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getReceiveBufferSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAlive(boolean bl) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setKeepAlive(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getKeepAlive() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getKeepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrafficClass(int n) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setTrafficClass(n);
            this.trafficClass = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrafficClass() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = this.opts().getTrafficClass();
            if (n < 0) {
                n = this.trafficClass;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReuseAddress(boolean bl) throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            this.opts().setReuseAddress(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getReuseAddress() throws SocketException {
        Object object = this.sc.stateLock();
        synchronized (object) {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return this.opts().getReuseAddress();
        }
    }

    public void close() throws IOException {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            Net.translateToSocketException(exception);
        }
    }

    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public String toString() {
        if (this.sc.isConnected()) {
            return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "Socket[unconnected]";
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    public boolean isBound() {
        return this.sc.isBound();
    }

    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    private class SocketInputStream
    extends ChannelInputStream {
        private SocketInputStream() {
            super(SocketAdaptor.this.sc);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = SocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!SocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (SocketAdaptor.this.timeout == 0) {
                    return SocketAdaptor.this.sc.read(byteBuffer);
                }
                SelectionKey selectionKey = null;
                Selector selector = null;
                SocketAdaptor.this.sc.configureBlocking(false);
                try {
                    long l;
                    int n = SocketAdaptor.this.sc.read(byteBuffer);
                    if (n != 0) {
                        int n2 = n;
                        Object var13_8 = null;
                        if (selectionKey != null) {
                            selectionKey.cancel();
                        }
                        if (SocketAdaptor.this.sc.isOpen()) {
                            SocketAdaptor.this.sc.configureBlocking(true);
                        }
                        if (selector == null) return n2;
                        Util.releaseTemporarySelector(selector);
                        return n2;
                    }
                    selector = Util.getTemporarySelector(SocketAdaptor.this.sc);
                    selectionKey = SocketAdaptor.this.sc.register(selector, 1);
                    long l2 = SocketAdaptor.this.timeout;
                    do {
                        if (!SocketAdaptor.this.sc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        l = System.currentTimeMillis();
                        int n3 = selector.select(l2);
                        if (n3 > 0 && selectionKey.isReadable() && (n = SocketAdaptor.this.sc.read(byteBuffer)) != 0) {
                            int n4 = n;
                            Object var13_9 = null;
                            if (selectionKey != null) {
                                selectionKey.cancel();
                            }
                            if (SocketAdaptor.this.sc.isOpen()) {
                                SocketAdaptor.this.sc.configureBlocking(true);
                            }
                            if (selector == null) return n4;
                            Util.releaseTemporarySelector(selector);
                            return n4;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (SocketAdaptor.this.sc.isOpen()) {
                        SocketAdaptor.this.sc.configureBlocking(true);
                    }
                    if (selector == null) throw throwable;
                    Util.releaseTemporarySelector(selector);
                    throw throwable;
                }
            }
        }
    }
}

