/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import productinstaller.ConnectionToServer;
import productinstaller.DiscsInstaller;
import productinstaller.IPanelAction;
import productinstaller.ListObject;
import productinstaller.ProductInstaller;
import productinstaller.XmlPrefs;

public class InstallingPanel
extends JPanel
implements IPanelAction {
    JLabel installingLab = new JLabel("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430");
    JProgressBar progressBar;
    ProductInstaller productInstaller;
    ArrayList<ListObject> selectedOptions;
    int o = 0;
    public static Preferences prefs;
    private XmlPrefs xmlPrefs;
    private String serverAnswer;

    public InstallingPanel(ProductInstaller productInstaller) {
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(10));
        this.add(this.installingLab);
        this.add(Box.createVerticalStrut(10));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10), BorderFactory.createLineBorder(Color.black, 1)));
        this.progressBar.setValue(0);
        this.add(this.progressBar);
        this.productInstaller = productInstaller;
        this.xmlPrefs = productInstaller.xmlPrefs;
        prefs = Preferences.userRoot().node("examenServer").node("products");
    }

    @Override
    public int PanelAction() {
        this.serverAnswer = ConnectionToServer.connect(this.productInstaller.getInstallPath() + System.getProperty("file.separator")).loginToServer();
        if (!this.serverAnswer.equalsIgnoreCase("null")) {
            int choise = JOptionPane.showConfirmDialog(this.productInstaller, "\u041f\u0435\u0440\u0435\u0434 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439 \u0443\u0447\u0435\u0431\u043d\u044b\u0445 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u043e\u0432 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0421\u0415\u0420\u0412\u0415\u0420.\n\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c?", "", 0);
            if (choise == 1 || choise == -1) {
                return 0;
            }
            if (choise == 0) {
                ConnectionToServer.connect(this.productInstaller.getInstallPath() + File.separator).sendRequest("{\"request\":\"installerStopRequest\"}");
            }
        }
        this.startInstall();
        return 1;
    }

    private void startInstall() {
        Task task = new Task();
        task.execute();
    }

    private void copyJre(String from, String to) {
        try {
            this.copyFolder(from, to);
        }
        catch (IOException ex) {
            Logger.getLogger(InstallingPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setProgress(int val) {
        this.progressBar.setValue(val);
    }

    public void setInstallLab(String val) {
        this.installingLab.setText(val);
    }

    public static void main(String[] args) {
        InstallingPanel.exec("d:\\Downloads\\arh\\arh_win\\arh.exe -uninstallAppSilent ExamenNetTeacher");
        InstallingPanel.exec("\"d:\\Other\\NetBeans 7.3.1\\Projects\\ProductInstalller\\AirInstaller\\win\\AdobeAIRInstaller.exe\" -silent -desktopShortcut -programMenu -location \"d:\\\u0421\u0415\u0420\u0412\u0415\u0420\\ExamenNetTeacher\" \"d:\\Other\\NetBeans 7.3.1\\Projects\\ProductInstalller\\ExamenNetTeacher\\ExamenNetTeacher.air\"");
    }

    public static int exec(String command) {
        int result = -1;
        try {
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(command);
            result = process.waitFor();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(InstallingPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static String[] execWithOutput(String command) {
        String[] output = new String[2];
        try {
            int n2;
            int n1;
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec(command);
            InputStream inputStream = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(inputStream);
            InputStream errorStream = process.getErrorStream();
            InputStreamReader esr = new InputStreamReader(errorStream);
            char[] c1 = new char[1024];
            StringBuffer standardOutput = new StringBuffer();
            while ((n1 = isr.read(c1)) > 0) {
                standardOutput.append(c1, 0, n1);
            }
            output[0] = standardOutput.toString();
            char[] c2 = new char[1024];
            StringBuffer standardError = new StringBuffer();
            while ((n2 = esr.read(c2)) > 0) {
                standardError.append(c2, 0, n2);
            }
            output[1] = standardError.toString();
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return output;
        }
    }

    private void copyFolder(String srcFolderPath, String destFolderPath) throws IOException {
        this.copyFolder(new File(srcFolderPath), new File(destFolderPath));
    }

    private void copyFolder(File srcFolderPath, File destFolderPath) throws IOException {
        this.progressBar.setValue(++this.o);
        if (!srcFolderPath.isDirectory()) {
            FileInputStream in = new FileInputStream(srcFolderPath);
            FileOutputStream out = new FileOutputStream(destFolderPath);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        } else {
            String[] folder_contents;
            if (!destFolderPath.exists()) {
                destFolderPath.mkdir();
            }
            for (String file : folder_contents = srcFolderPath.list()) {
                File srcFile = new File(srcFolderPath, file);
                File destFile = new File(destFolderPath, file);
                this.copyFolder(srcFile, destFile);
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        String chapter;
        public String serverAnswer;

        Task() {
        }

        @Override
        protected Void doInBackground() {
            try {
                InstallingPanel.this.productInstaller.toggleNextButton(false);
                InstallingPanel.this.productInstaller.toggleCloseButton(false);
                String installPath = InstallingPanel.this.productInstaller.getInstallPath();
                InstallingPanel.this.selectedOptions = InstallingPanel.this.productInstaller.getSelectedOptions();
                if (InstallingPanel.this.xmlPrefs.getInstallPrefAsBoolean("copyJre")) {
                    InstallingPanel.this.copyJre("jre", installPath + File.separator + "jre");
                }
                for (int i = 0; i < InstallingPanel.this.selectedOptions.size(); ++i) {
                    ListObject listObject = InstallingPanel.this.selectedOptions.get(i);
                    String sourceDir = listObject.getSourceDir();
                    String optionType = listObject.getType();
                    if (optionType.equals("application")) {
                        File from = new File(sourceDir);
                        File to = new File(installPath + File.separator + sourceDir);
                        try {
                            if (!to.exists()) {
                                to.mkdirs();
                            }
                            InstallingPanel.this.copyFolder(from, to);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(InstallingPanel.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (optionType.equals("disc")) {
                        String to = installPath;
                        DiscsInstaller discInstaller = new DiscsInstaller(sourceDir, to, InstallingPanel.this, this.serverAnswer);
                        discInstaller.installDisc();
                    }
                    if (!optionType.equals("client")) continue;
                    String clientName = listObject.getSourceDir();
                    String sep = File.separator;
                    String OS = InstallingPanel.this.productInstaller.getOsType();
                    String workingDir = System.getProperty("user.dir");
                    if (OS.equals("win")) {
                        String arhFile = new File(String.format("arh%sarh_%s", sep, OS)).listFiles()[0].getName();
                        int res = InstallingPanel.exec(String.format("arh%sarh_%s%s%s -uninstallAppSilent %s", sep, OS, sep, arhFile, clientName));
                        String airFile = new File(String.format("AirInstaller%s%s", sep, OS)).listFiles()[0].getName();
                        res = InstallingPanel.exec(String.format("\"AirInstaller%s%s%s%s\" -silent -desktopShortcut -programMenu -location \"%s%s%s\" \"%s%s%s\"", sep, OS, sep, airFile, installPath, sep, clientName, sourceDir, sep, OS.equals("nix") ? OS + sep + clientName + ".air" : clientName + ".air"));
                    }
                    if (!OS.equals("nix")) continue;
                    InstallingPanel.exec("sudo chmod +x 'arh" + sep + "arh_nix" + sep + "arh'");
                    InstallingPanel.exec("sudo ./'arh" + sep + "arh_nix" + sep + "arh' -uninstallAppSilent " + clientName);
                    InstallingPanel.exec("sudo chmod +x 'AirInstaller" + sep + "nix" + sep + "AdobeAIRInstaller.bin'");
                    InstallingPanel.exec("sudo ./'AirInstaller" + sep + "nix" + sep + "AdobeAIRInstaller.bin' -silent -desktopShortcut -programMenu -location " + "'" + sourceDir + "' '" + clientName + sep + "nix" + sep + clientName + ".air'");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(InstallingPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }

        @Override
        protected void done() {
            InstallingPanel.this.productInstaller.toggleNextButton(true);
            InstallingPanel.this.productInstaller.setNextButtonLabel("\u0433\u043e\u0442\u043e\u0432\u043e");
            ConnectionToServer.connect(InstallingPanel.this.productInstaller.getInstallPath() + File.separator).sendRequest("{\"request\":\"installerStartRequest\"}");
            InstallingPanel.this.productInstaller.toggleCloseButton(true);
        }
    }
}

