/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ButtonConfig;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    protected AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private boolean result = true;
    private static PrintWriter logfile = null;
    private String logfiledir = null;
    protected AutomatedInstallData idata;
    private Map<Boolean, List<ButtonConfig>> buttonConfigs = new Hashtable<Boolean, List<ButtonConfig>>();

    public ProcessPanelWorker(AutomatedInstallData automatedInstallData, AbstractUIProcessHandler abstractUIProcessHandler) throws IOException {
        this.handler = abstractUIProcessHandler;
        this.idata = automatedInstallData;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariables());
    }

    private boolean readSpec() throws IOException {
        String string;
        IXMLElement iXMLElement;
        InputStream inputStream;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        XMLParser xMLParser = new XMLParser();
        try {
            iXMLElement = xMLParser.parse(inputStream);
        }
        catch (Exception exception) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(exception.toString());
            return false;
        }
        if (!iXMLElement.hasChildren()) {
            return false;
        }
        IXMLElement iXMLElement2 = iXMLElement.getFirstChildNamed("logfiledir");
        if (iXMLElement2 != null) {
            this.logfiledir = iXMLElement2.getContent();
        }
        for (IXMLElement iXMLElement3 : iXMLElement.getChildrenNamed("job")) {
            Object object2;
            ArrayList<String> arrayList;
            String string2;
            List<OsConstraint> list;
            Serializable serializable;
            String string3 = iXMLElement3.hasAttribute("condition") ? iXMLElement3.getAttribute("condition") : (string = iXMLElement3.hasAttribute("conditionid") ? iXMLElement3.getAttribute("conditionid") : null);
            if (string != null && string.length() > 0) {
                Debug.trace("Condition for job.");
                serializable = RulesEngine.getCondition(string);
                if (serializable != null && !((Condition)serializable).isTrue()) {
                    Debug.trace("condition is not fulfilled.");
                    continue;
                }
            }
            Debug.trace("Condition is fulfilled or not existent.");
            serializable = iXMLElement3.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor((Vector<IXMLElement>)serializable) || !OsConstraint.oneMatchesCurrentSystem(list = OsConstraint.getOsList(iXMLElement3))) continue;
            ArrayList<Processable> arrayList2 = new ArrayList<Processable>();
            String string4 = iXMLElement3.getAttribute("name", "");
            for (IXMLElement iXMLElement4 : iXMLElement3.getChildrenNamed("executefile")) {
                string2 = iXMLElement4.getAttribute("name");
                if (string2 == null || string2.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executefile>");
                    return false;
                }
                arrayList = new ArrayList<String>();
                for (IXMLElement iXMLElement5 : iXMLElement4.getChildrenNamed("arg")) {
                    object2 = iXMLElement5.getContent();
                    arrayList.add((String)object2);
                }
                Iterator<IXMLElement> iterator = new ArrayList();
                for (Object object2 : iXMLElement4.getChildrenNamed("env")) {
                    String string5 = object2.getContent();
                    iterator.add((IXMLElement)((Object)string5));
                }
                arrayList2.add(new ExecutableFile(string2, (List<String>)arrayList, (List<String>)((Object)iterator)));
            }
            for (IXMLElement iXMLElement4 : iXMLElement3.getChildrenNamed("executeclass")) {
                string2 = iXMLElement4.getAttribute("name");
                if (string2 == null || string2.length() == 0) {
                    System.err.println("missing \"name\" attribute for <executeclass>");
                    return false;
                }
                arrayList = new ArrayList();
                for (IXMLElement iXMLElement6 : iXMLElement4.getChildrenNamed("arg")) {
                    object2 = iXMLElement6.getContent();
                    arrayList.add((String)object2);
                }
                arrayList2.add(new ExecutableClass(string2, arrayList));
            }
            this.jobs.add(new ProcessingJob(string4, arrayList2));
        }
        this.buttonConfigs.put(Boolean.FALSE, new ArrayList());
        this.buttonConfigs.put(Boolean.TRUE, new ArrayList());
        for (IXMLElement iXMLElement3 : iXMLElement.getChildrenNamed("onFail")) {
            string = iXMLElement3.hasAttribute("condition") ? iXMLElement3.getAttribute("condition") : (iXMLElement3.hasAttribute("conditionid") ? iXMLElement3.getAttribute("conditionid") : null);
            boolean bl = iXMLElement3.hasAttribute("previous") ? Boolean.parseBoolean(iXMLElement3.getAttribute("previous")) : false;
            boolean bl2 = iXMLElement3.hasAttribute("next") ? Boolean.parseBoolean(iXMLElement3.getAttribute("next")) : false;
            this.buttonConfigs.get(Boolean.FALSE).add(new ButtonConfig(string, bl, bl2));
        }
        for (IXMLElement iXMLElement3 : iXMLElement.getChildrenNamed("onSuccess")) {
            string = iXMLElement3.hasAttribute("condition") ? iXMLElement3.getAttribute("condition") : (iXMLElement3.hasAttribute("conditionid") ? iXMLElement3.getAttribute("conditionid") : null);
            boolean bl = iXMLElement3.hasAttribute("previous") ? Boolean.parseBoolean(iXMLElement3.getAttribute("previous")) : false;
            this.buttonConfigs.get(Boolean.TRUE).add(new ButtonConfig(string, bl, true));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        boolean bl;
        try {
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return;
        }
        if (this.logfiledir != null) {
            void var2_7;
            this.logfiledir = IoHelper.translatePath(this.logfiledir, new VariableSubstitutor(this.idata.getVariables()));
            String object = this.idata.getVariable("APP_VER");
            if (object != null) {
                String bl2 = "V" + object;
            } else {
                String string = "undef";
            }
            Object object2 = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            object2 = var2_7.replace(' ', '_') + "_" + (String)object2;
            try {
                File file = File.createTempFile("Install_" + (String)object2 + "_", ".log", new File(this.logfiledir));
                logfile = new PrintWriter(new FileOutputStream(file), true);
            }
            catch (IOException iOException) {
                Debug.error(iOException);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob processingJob : this.jobs) {
            this.handler.startProcess(processingJob.name);
            this.result = processingJob.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        for (ButtonConfig buttonConfig : this.buttonConfigs.get(this.result)) {
            String string = buttonConfig.getConditionid();
            if (string != null && string.length() > 0) {
                Debug.trace("Condition for job.");
                Condition condition = RulesEngine.getCondition(string);
                if (condition != null && !condition.isTrue()) {
                    Debug.trace("condition is not fulfilled.");
                    continue;
                }
            }
            bl2 = buttonConfig.isUnlockNext();
            bl = buttonConfig.isUnlockPrev();
            break;
        }
        this.handler.finishProcessing(bl, bl2);
        if (logfile != null) {
            logfile.close();
        }
    }

    public void startThread() {
        Thread thread = new Thread((Runnable)this, "processing thread");
        thread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(Vector<IXMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = this.idata.selectedPacks.get((int)i).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        protected AbstractUIProcessHandler myHandler;

        public ExecutableClass(String string, List<String> list) {
            this.myClassName = string;
            this.myArguments = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            boolean bl = false;
            this.myHandler = abstractUIProcessHandler;
            String[] stringArray = new String[this.myArguments.size()];
            int n = 0;
            for (String object : this.myArguments) {
                stringArray[n++] = variableSubstitutor.substitute(object, "plain");
            }
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass(this.myClassName);
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                if (method.getReturnType().getName().equals("boolean")) {
                    bl = (Boolean)method.invoke(obj, this.myHandler, stringArray);
                } else {
                    method.invoke(obj, this.myHandler, stringArray);
                    bl = true;
                }
            }
            catch (SecurityException securityException) {
                this.myHandler.emitError("Post Processing Error", "Security exception thrown when processing class: " + this.myClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.myHandler.emitError("Post Processing Error", "Cannot find processing class: " + this.myClassName);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.myHandler.emitError("Post Processing Error", "Processing class does not have 'run' method: " + this.myClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.myHandler.emitError("Post Processing Error", "Error accessing processing class: " + this.myClassName);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.myHandler.emitError("Post Processing Error", "Invocation Problem calling : " + this.myClassName + ", " + invocationTargetException.getCause().getMessage());
            }
            catch (Exception exception) {
                this.myHandler.emitError("Post Processing Error", "Exception when running processing class: " + this.myClassName + ", " + exception.getMessage());
            }
            catch (Error error) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + error.getMessage());
            }
            catch (Throwable throwable) {
                this.myHandler.emitError("Post Processing Error", "Error when running processing class: " + this.myClassName + ", " + throwable.getMessage());
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutableFile
    implements Processable {
        private String filename;
        private List<String> arguments;
        private List<String> envvariables;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String string, List<String> list, List<String> list2) {
            this.filename = string;
            this.arguments = list;
            this.envvariables = list2;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            Object object;
            this.handler = abstractUIProcessHandler;
            ArrayList<String> arrayList = new ArrayList<String>(this.arguments.size() + 1);
            arrayList.add(variableSubstitutor.substitute(this.filename, "plain"));
            for (String object22 : this.arguments) {
                arrayList.add(variableSubstitutor.substitute(object22, "plain"));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Map<String, String> map = processBuilder.environment();
            for (String string : this.envvariables) {
                object = variableSubstitutor.substitute(string, "plain");
                int n = ((String)object).indexOf("=");
                if (n <= 0) continue;
                map.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
            }
            try {
                Process iOException = processBuilder.start();
                OutputMonitor outputMonitor = new OutputMonitor(this.handler, iOException.getInputStream(), false);
                object = new OutputMonitor(this.handler, iOException.getErrorStream(), true);
                Thread thread = new Thread(outputMonitor);
                Thread thread2 = new Thread((Runnable)object);
                thread.setDaemon(true);
                thread2.setDaemon(true);
                thread.start();
                thread2.start();
                try {
                    int n = iOException.waitFor();
                    this.stopMonitor(outputMonitor, thread);
                    this.stopMonitor((OutputMonitor)object, thread2);
                    if (n != 0 && this.handler.askQuestion("Process execution failed", "Continue anyway?", 37, 47) == 49) {
                        return false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    iOException.destroy();
                    this.handler.emitError("process interrupted", interruptedException.toString());
                    return false;
                }
            }
            catch (IOException iOException) {
                this.handler.emitError("I/O error", iOException.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor outputMonitor, Thread thread) {
            outputMonitor.doStop();
            long l = 500L;
            try {
                thread.join(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) {
                return;
            }
            thread.interrupt();
            long l2 = 500L;
            try {
                thread.join(l2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public static class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler abstractUIProcessHandler, InputStream inputStream, boolean bl) {
                this.stderr = bl;
                this.reader = new BufferedReader(new InputStreamReader(inputStream));
                this.handler = abstractUIProcessHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        this.handler.logOutput(string, this.stderr);
                        if (logfile != null) {
                            logfile.println(string);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    this.handler.logOutput(iOException.toString(), true);
                    if (logfile == null) return;
                    logfile.println(iOException.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessingJob
    implements Processable {
        public String name;
        private List<Processable> processables;

        public ProcessingJob(String string, List<Processable> list) {
            this.name = string;
            this.processables = list;
        }

        @Override
        public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, VariableSubstitutor variableSubstitutor) {
            for (Processable processable : this.processables) {
                if (processable.run(abstractUIProcessHandler, variableSubstitutor)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

