/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import sun.swing.SwingUtilities2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    public static final int UPDATE_WHEN_ON_EDT = 0;
    public static final int NEVER_UPDATE = 1;
    public static final int ALWAYS_UPDATE = 2;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    JTextComponent component;
    int updatePolicy = 0;
    boolean visible;
    boolean active;
    int dot;
    int mark;
    Object selectionTag;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    transient Position.Bias dotBias;
    transient Position.Bias markBias;
    boolean dotLTR;
    boolean markLTR;
    transient Handler handler = new Handler();
    private transient int[] flagXPoints = new int[3];
    private transient int[] flagYPoints = new int[3];
    private transient NavigationFilter.FilterBypass filterBypass;
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    private transient MouseEvent selectedWordEvent = null;
    private int caretWidth = -1;
    private float aspectRatio = -1.0f;

    public void setUpdatePolicy(int n) {
        this.updatePolicy = n;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    protected final JTextComponent getComponent() {
        return this.component;
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            int n = this.getCaretWidth(rectangle.height);
            this.x = rectangle.x - 4 - (n >> 1);
            this.y = rectangle.y;
            this.width = 9 + n;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (this.component == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.component.scrollRectToVisible(rectangle);
        } else {
            SwingUtilities.invokeLater(new SafeScroller(rectangle));
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.setDot(n, biasArray[0]);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Position.Bias[] biasArray = new Position.Bias[1];
        int n = this.component.getUI().viewToModel(this.component, point, biasArray);
        if (biasArray[0] == null) {
            biasArray[0] = Position.Bias.Forward;
        }
        if (n >= 0) {
            this.moveDot(n, biasArray[0]);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || focusEvent.isTemporary());
    }

    private void selectWord(MouseEvent mouseEvent) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == mouseEvent.getX() && this.selectedWordEvent.getY() == mouseEvent.getY()) {
            return;
        }
        Action action = null;
        ActionMap actionMap = this.getComponent().getActionMap();
        if (actionMap != null) {
            action = actionMap.get("select-word");
        }
        if (action == null) {
            if (selectWord == null) {
                selectWord = new DefaultEditorKit.SelectWordAction();
            }
            action = selectWord;
        }
        action.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        this.selectedWordEvent = mouseEvent;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        block18: {
            int n = SwingUtilities2.getAdjustedClickCount(this.getComponent(), mouseEvent);
            if (!mouseEvent.isConsumed()) {
                JTextComponent jTextComponent;
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (n == 1) {
                        this.selectedWordEvent = null;
                    } else if (n == 2 && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent)) {
                        this.selectWord(mouseEvent);
                        this.selectedWordEvent = null;
                    } else if (n == 3 && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent)) {
                        Action action = null;
                        ActionMap actionMap = this.getComponent().getActionMap();
                        if (actionMap != null) {
                            action = actionMap.get("select-line");
                        }
                        if (action == null) {
                            if (selectLine == null) {
                                selectLine = new DefaultEditorKit.SelectLineAction();
                            }
                            action = selectLine;
                        }
                        action.actionPerformed(new ActionEvent(this.getComponent(), 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }
                } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n == 1 && this.component.isEditable() && this.component.isEnabled() && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent) && (jTextComponent = (JTextComponent)mouseEvent.getSource()) != null) {
                    try {
                        Toolkit toolkit = jTextComponent.getToolkit();
                        Clipboard clipboard = toolkit.getSystemSelection();
                        if (clipboard == null) break block18;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = jTextComponent.getTransferHandler();
                        if (transferHandler != null) {
                            Transferable transferable = null;
                            try {
                                transferable = clipboard.getContents(null);
                            }
                            catch (IllegalStateException illegalStateException) {
                                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                            }
                            if (transferable != null) {
                                transferHandler.importData(jTextComponent, transferable);
                            }
                        }
                        this.adjustFocus(true);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = SwingUtilities2.getAdjustedClickCount(this.getComponent(), mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(mouseEvent);
                if (n == 2 && SwingUtilities2.canEventAccessSystemClipboard(mouseEvent)) {
                    this.selectWord(mouseEvent);
                }
            }
        }
    }

    void adjustCaretAndFocus(MouseEvent mouseEvent) {
        this.adjustCaret(mouseEvent);
        this.adjustFocus(false);
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else if (!mouseEvent.isPopupTrigger()) {
            this.positionCaret(mouseEvent);
        }
    }

    private void adjustFocus(boolean bl) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (bl) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.adjustCaretAndFocus(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                Element element;
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                if (rectangle == null || rectangle.width == 0 && rectangle.height == 0) {
                    return;
                }
                if (this.width > 0 && this.height > 0 && !this._contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                    Rectangle rectangle2 = graphics.getClipBounds();
                    if (rectangle2 != null && !rectangle2.contains(this)) {
                        this.repaint();
                    }
                    this.damage(rectangle);
                }
                graphics.setColor(this.component.getCaretColor());
                int n = this.getCaretWidth(rectangle.height);
                rectangle.x -= n >> 1;
                graphics.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
                Document document = this.component.getDocument();
                if (document instanceof AbstractDocument && (element = ((AbstractDocument)document).getBidiRootElement()) != null && element.getElementCount() > 1) {
                    this.flagXPoints[0] = rectangle.x + (this.dotLTR ? n : 0);
                    this.flagYPoints[0] = rectangle.y;
                    this.flagXPoints[1] = this.flagXPoints[0];
                    this.flagYPoints[1] = this.flagYPoints[0] + 4;
                    this.flagXPoints[2] = this.flagXPoints[0] + (this.dotLTR ? 4 : -4);
                    this.flagYPoints[2] = this.flagYPoints[0];
                    graphics.fillPolygon(this.flagXPoints, this.flagYPoints, 3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        Number number;
        this.component = jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        this.markLTR = true;
        this.dotLTR = true;
        this.dotBias = this.markBias = Position.Bias.Forward;
        if (document != null) {
            document.addDocumentListener(this.handler);
        }
        jTextComponent.addPropertyChangeListener(this.handler);
        jTextComponent.addFocusListener(this);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
        this.aspectRatio = (number = (Number)jTextComponent.getClientProperty("caretAspectRatio")) != null ? number.floatValue() : -1.0f;
        Integer n = (Integer)jTextComponent.getClientProperty("caretWidth");
        this.caretWidth = n != null ? n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JTextComponent jTextComponent) {
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeFocusListener(this);
        jTextComponent.removePropertyChangeListener(this.handler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.handler);
        }
        DefaultCaret defaultCaret = this;
        synchronized (defaultCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        if (bl != this.selectionVisible) {
            this.selectionVisible = bl;
            if (this.selectionVisible) {
                Highlighter highlighter = this.component.getHighlighter();
                if (this.dot != this.mark && highlighter != null && this.selectionTag == null) {
                    int n = Math.min(this.dot, this.mark);
                    int n2 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                    try {
                        this.selectionTag = highlighter.addHighlight(n, n2, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter highlighter = this.component.getHighlighter();
                highlighter.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    @Override
    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.component != null) {
            this.active = bl;
            TextUI textUI = this.component.getUI();
            if (this.visible != bl) {
                this.visible = bl;
                try {
                    Rectangle rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    @Override
    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.handler);
            }
            this.flasher.setDelay(n);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.handler);
            this.flasher = null;
        }
    }

    @Override
    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    @Override
    public int getDot() {
        return this.dot;
    }

    @Override
    public int getMark() {
        return this.mark;
    }

    @Override
    public void setDot(int n) {
        this.setDot(n, Position.Bias.Forward);
    }

    @Override
    public void moveDot(int n) {
        this.moveDot(n, Position.Bias.Forward);
    }

    public void moveDot(int n, Position.Bias bias) {
        if (bias == null) {
            throw new IllegalArgumentException("null bias");
        }
        if (!this.component.isEnabled()) {
            this.setDot(n, bias);
            return;
        }
        if (n != this.dot) {
            NavigationFilter navigationFilter = this.component.getNavigationFilter();
            if (navigationFilter != null) {
                navigationFilter.moveDot(this.getFilterBypass(), n, bias);
            } else {
                this.handleMoveDot(n, bias);
            }
        }
    }

    void handleMoveDot(int n, Position.Bias bias) {
        Highlighter highlighter;
        this.changeCaretPosition(n, bias);
        if (this.selectionVisible && (highlighter = this.component.getHighlighter()) != null) {
            int n2;
            int n3 = Math.min(n, this.mark);
            if (n3 == (n2 = Math.max(n, this.mark))) {
                if (this.selectionTag != null) {
                    highlighter.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n3, n2);
                    } else {
                        Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                        this.selectionTag = highlighter.addHighlight(n3, n2, highlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new StateInvariantError("Bad caret position");
                }
            }
        }
    }

    public void setDot(int n, Position.Bias bias) {
        if (bias == null) {
            throw new IllegalArgumentException("null bias");
        }
        NavigationFilter navigationFilter = this.component.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.setDot(this.getFilterBypass(), n, bias);
        } else {
            this.handleSetDot(n, bias);
        }
    }

    void handleSetDot(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
        }
        if ((n = Math.max(n, 0)) == 0) {
            bias = Position.Bias.Forward;
        }
        this.mark = n;
        if (this.dot != n || this.dotBias != bias || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(n, bias);
        }
        this.markBias = this.dotBias;
        this.markLTR = this.dotLTR;
        Highlighter highlighter = this.component.getHighlighter();
        if (highlighter != null && this.selectionTag != null) {
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public Position.Bias getDotBias() {
        return this.dotBias;
    }

    public Position.Bias getMarkBias() {
        return this.markBias;
    }

    boolean isDotLeftToRight() {
        return this.dotLTR;
    }

    boolean isMarkLeftToRight() {
        return this.markLTR;
    }

    boolean isPositionLTR(int n, Position.Bias bias) {
        Document document = this.component.getDocument();
        if (document instanceof AbstractDocument) {
            if (bias == Position.Bias.Backward && --n < 0) {
                n = 0;
            }
            return ((AbstractDocument)document).isLeftToRight(n, n);
        }
        return true;
    }

    Position.Bias guessBiasForOffset(int n, Position.Bias bias, boolean bl) {
        if (bl != this.isPositionLTR(n, bias)) {
            bias = Position.Bias.Backward;
        } else if (bias != Position.Bias.Backward && bl != this.isPositionLTR(n, Position.Bias.Backward)) {
            bias = Position.Bias.Backward;
        }
        if (bias == Position.Bias.Backward && n > 0) {
            try {
                Segment segment = new Segment();
                this.component.getDocument().getText(n - 1, 1, segment);
                if (segment.count > 0 && segment.array[segment.offset] == '\n') {
                    bias = Position.Bias.Forward;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return bias;
    }

    void changeCaretPosition(int n, Position.Bias bias) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = n;
        this.dotBias = bias;
        this.dotLTR = this.isPositionLTR(n, bias);
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            Document document = this.component.getDocument();
            if (textUI != null && document != null) {
                Rectangle rectangle;
                try {
                    rectangle = textUI.modelToView(this.component, this.dot, this.dotBias);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null) {
                    this.adjustVisibility(rectangle);
                    if (this.getMagicCaretPosition() == null) {
                        this.setMagicCaretPosition(new Point(rectangle.x, rectangle.y));
                    }
                }
                this.damage(rectangle);
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (!SwingUtilities2.canCurrentEventAccessSystemClipboard()) {
            return;
        }
        if (this.dot != this.mark && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            String string = null;
            if (this.component instanceof JPasswordField && this.component.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                StringBuffer stringBuffer = null;
                char c = ((JPasswordField)this.component).getEchoChar();
                int n = Math.min(this.getDot(), this.getMark());
                int n2 = Math.max(this.getDot(), this.getMark());
                for (int i = n; i < n2; ++i) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
                string = stringBuffer != null ? stringBuffer.toString() : null;
            } else {
                string = this.component.getSelectedText();
            }
            try {
                clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
                this.ownsSelection = true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private ClipboardOwner getClipboardOwner() {
        return this.handler;
    }

    private void ensureValidPosition() {
        int n = this.component.getDocument().getLength();
        if (this.dot > n || this.mark > n) {
            this.handleSetDot(n, Position.Bias.Forward);
        }
    }

    @Override
    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    @Override
    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public String toString() {
        String string = "Dot=(" + this.dot + ", " + this.dotBias + ")";
        string = string + " Mark=(" + this.mark + ", " + this.markBias + ")";
        return string;
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    private boolean _contains(int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        if ((n5 | n6 | n3 | n4) < 0) {
            return false;
        }
        int n7 = this.x;
        int n8 = this.y;
        if (n < n7 || n2 < n8) {
            return false;
        }
        if (n3 > 0) {
            n5 += n7;
            if ((n3 += n) <= n ? n5 >= n7 || n3 > n5 : n5 >= n7 && n3 > n5) {
                return false;
            }
        } else if (n7 + n5 < n) {
            return false;
        }
        if (n4 > 0) {
            n6 += n8;
            if ((n4 += n2) <= n2 ? n6 >= n8 || n4 > n6 : n6 >= n8 && n4 > n6) {
                return false;
            }
        } else if (n8 + n6 < n2) {
            return false;
        }
        return true;
    }

    int getCaretWidth(int n) {
        if (this.aspectRatio > -1.0f) {
            return (int)(this.aspectRatio * (float)n) + 1;
        }
        if (this.caretWidth > -1) {
            return this.caretWidth;
        }
        Object object = UIManager.get("Caret.width");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.handler = new Handler();
        this.dotBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
        this.markBias = !objectInputStream.readBoolean() ? Position.Bias.Forward : Position.Bias.Backward;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.dotBias == Position.Bias.Backward);
        objectOutputStream.writeBoolean(this.markBias == Position.Bias.Backward);
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Caret getCaret() {
            return DefaultCaret.this;
        }

        public void setDot(int n, Position.Bias bias) {
            DefaultCaret.this.handleSetDot(n, bias);
        }

        public void moveDot(int n, Position.Bias bias) {
            DefaultCaret.this.handleMoveDot(n, bias);
        }
    }

    class Handler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener,
    ClipboardOwner {
        Handler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((DefaultCaret.this.width == 0 || DefaultCaret.this.height == 0) && DefaultCaret.this.component != null) {
                TextUI textUI = DefaultCaret.this.component.getUI();
                try {
                    Rectangle rectangle = textUI.modelToView(DefaultCaret.this.component, DefaultCaret.this.dot, DefaultCaret.this.dotBias);
                    if (rectangle != null && rectangle.width != 0 && rectangle.height != 0) {
                        DefaultCaret.this.damage(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            DefaultCaret.this.visible = !DefaultCaret.this.visible;
            DefaultCaret.this.repaint();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                if ((documentEvent.getOffset() <= DefaultCaret.this.dot || documentEvent.getOffset() <= DefaultCaret.this.mark) && DefaultCaret.this.selectionTag != null) {
                    try {
                        DefaultCaret.this.component.getHighlighter().changeHighlight(DefaultCaret.this.selectionTag, Math.min(DefaultCaret.this.dot, DefaultCaret.this.mark), Math.max(DefaultCaret.this.dot, DefaultCaret.this.mark));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                return;
            }
            boolean bl = false;
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            int n4 = DefaultCaret.this.dot;
            short s = 0;
            if (documentEvent instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(n2 + n3);
                return;
            }
            if (n4 >= n2) {
                n4 += n3;
                s = (short)(s | 1);
            }
            if ((n = DefaultCaret.this.mark) >= n2) {
                n += n3;
                s = (short)(s | 2);
            }
            if (s != 0) {
                Position.Bias bias = DefaultCaret.this.dotBias;
                if (DefaultCaret.this.dot == n2) {
                    boolean bl2;
                    Document document = DefaultCaret.this.component.getDocument();
                    try {
                        Segment segment = new Segment();
                        document.getText(n4 - 1, 1, segment);
                        bl2 = segment.count > 0 && segment.array[segment.offset] == '\n';
                    }
                    catch (BadLocationException badLocationException) {
                        bl2 = false;
                    }
                    bias = bl2 ? Position.Bias.Forward : Position.Bias.Backward;
                }
                if (n == n4) {
                    DefaultCaret.this.setDot(n4, bias);
                    DefaultCaret.this.ensureValidPosition();
                } else {
                    DefaultCaret.this.setDot(n, DefaultCaret.this.markBias);
                    if (DefaultCaret.this.getDot() == n) {
                        DefaultCaret.this.moveDot(n4, bias);
                    }
                    DefaultCaret.this.ensureValidPosition();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                int n = DefaultCaret.this.component.getDocument().getLength();
                DefaultCaret.this.dot = Math.min(DefaultCaret.this.dot, n);
                DefaultCaret.this.mark = Math.min(DefaultCaret.this.mark, n);
                if ((documentEvent.getOffset() < DefaultCaret.this.dot || documentEvent.getOffset() < DefaultCaret.this.mark) && DefaultCaret.this.selectionTag != null) {
                    try {
                        DefaultCaret.this.component.getHighlighter().changeHighlight(DefaultCaret.this.selectionTag, Math.min(DefaultCaret.this.dot, DefaultCaret.this.mark), Math.max(DefaultCaret.this.dot, DefaultCaret.this.mark));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                return;
            }
            int n = documentEvent.getOffset();
            int n2 = n + documentEvent.getLength();
            boolean bl = false;
            int n3 = DefaultCaret.this.dot;
            boolean bl2 = false;
            int n4 = DefaultCaret.this.mark;
            boolean bl3 = false;
            if (documentEvent instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(n);
                return;
            }
            if (n3 >= n2) {
                if ((n3 -= n2 - n) == n2) {
                    bl2 = true;
                }
            } else if (n3 >= n) {
                n3 = n;
                bl2 = true;
            }
            if (n4 >= n2) {
                if ((n4 -= n2 - n) == n2) {
                    bl3 = true;
                }
            } else if (n4 >= n) {
                n4 = n;
                bl3 = true;
            }
            if (n4 == n3) {
                DefaultCaret.this.forceCaretPositionChange = true;
                try {
                    DefaultCaret.this.setDot(n3, DefaultCaret.this.guessBiasForOffset(n3, DefaultCaret.this.dotBias, DefaultCaret.this.dotLTR));
                }
                finally {
                    DefaultCaret.this.forceCaretPositionChange = false;
                }
                DefaultCaret.this.ensureValidPosition();
            } else {
                Position.Bias bias = DefaultCaret.this.dotBias;
                Position.Bias bias2 = DefaultCaret.this.markBias;
                if (bl2) {
                    bias = DefaultCaret.this.guessBiasForOffset(n3, bias, DefaultCaret.this.dotLTR);
                }
                if (bl3) {
                    bias2 = DefaultCaret.this.guessBiasForOffset(DefaultCaret.this.mark, bias2, DefaultCaret.this.markLTR);
                }
                DefaultCaret.this.setDot(n4, bias2);
                if (DefaultCaret.this.getDot() == n4) {
                    DefaultCaret.this.moveDot(n3, bias);
                }
                DefaultCaret.this.ensureValidPosition();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.getUpdatePolicy() == 1 || DefaultCaret.this.getUpdatePolicy() == 0 && !SwingUtilities.isEventDispatchThread()) {
                return;
            }
            if (documentEvent instanceof AbstractDocument.UndoRedoDocumentEvent) {
                DefaultCaret.this.setDot(documentEvent.getOffset() + documentEvent.getLength());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                DefaultCaret.this.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (DefaultCaret.this.component.isFocusOwner()) {
                    if (bl == Boolean.TRUE) {
                        if (DefaultCaret.this.component.isEditable()) {
                            DefaultCaret.this.setVisible(true);
                        }
                        DefaultCaret.this.setSelectionVisible(true);
                    } else {
                        DefaultCaret.this.setVisible(false);
                        DefaultCaret.this.setSelectionVisible(false);
                    }
                }
            } else if ("caretWidth".equals(propertyChangeEvent.getPropertyName())) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                if (n != null) {
                    DefaultCaret.this.caretWidth = n;
                } else {
                    DefaultCaret.this.caretWidth = -1;
                }
                DefaultCaret.this.repaint();
            } else if ("caretAspectRatio".equals(propertyChangeEvent.getPropertyName())) {
                Number number = (Number)propertyChangeEvent.getNewValue();
                if (number != null) {
                    DefaultCaret.this.aspectRatio = number.floatValue();
                } else {
                    DefaultCaret.this.aspectRatio = -1.0f;
                }
                DefaultCaret.this.repaint();
            }
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            if (DefaultCaret.this.ownsSelection) {
                DefaultCaret.this.ownsSelection = false;
                if (DefaultCaret.this.component != null && !DefaultCaret.this.component.hasFocus()) {
                    DefaultCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            if (DefaultCaret.this.component != null) {
                DefaultCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

