/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelStandardIndexedDirector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelInstrument
extends Instrument {
    protected ModelInstrument(Soundbank soundbank, Patch patch, String string, Class<?> clazz) {
        super(soundbank, patch, string, clazz);
    }

    public ModelDirector getDirector(ModelPerformer[] modelPerformerArray, MidiChannel midiChannel, ModelDirectedPlayer modelDirectedPlayer) {
        return new ModelStandardIndexedDirector(modelPerformerArray, modelDirectedPlayer);
    }

    public ModelPerformer[] getPerformers() {
        return new ModelPerformer[0];
    }

    public ModelChannelMixer getChannelMixer(MidiChannel midiChannel, AudioFormat audioFormat) {
        return null;
    }

    public Patch getPatchAlias() {
        Patch patch = this.getPatch();
        int n = patch.getProgram();
        int n2 = patch.getBank();
        if (n2 != 0) {
            return patch;
        }
        boolean bl = false;
        if (this.getPatch() instanceof ModelPatch) {
            bl = ((ModelPatch)this.getPatch()).isPercussion();
        }
        if (bl) {
            return new Patch(15360, n);
        }
        return new Patch(15488, n);
    }

    public String[] getKeys() {
        String[] stringArray = new String[128];
        for (ModelPerformer modelPerformer : this.getPerformers()) {
            for (int i = modelPerformer.getKeyFrom(); i <= modelPerformer.getKeyTo(); ++i) {
                if (i < 0 || i >= 128 || stringArray[i] != null) continue;
                String string = modelPerformer.getName();
                if (string == null) {
                    string = "untitled";
                }
                stringArray[i] = string;
            }
        }
        return stringArray;
    }

    public boolean[] getChannels() {
        boolean bl = false;
        if (this.getPatch() instanceof ModelPatch) {
            bl = ((ModelPatch)this.getPatch()).isPercussion();
        }
        if (bl) {
            boolean[] blArray = new boolean[16];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = false;
            }
            blArray[9] = true;
            return blArray;
        }
        int n = this.getPatch().getBank();
        if (n >> 7 == 120 || n >> 7 == 121) {
            boolean[] blArray = new boolean[16];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
            return blArray;
        }
        boolean[] blArray = new boolean[16];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        blArray[9] = false;
        return blArray;
    }
}

