/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import sun.plugin2.main.server.JVMManager;
import sun.plugin2.os.windows.OSVERSIONINFOA;
import sun.plugin2.os.windows.Windows;

public class SystemUtil {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static final boolean VERBOSE = SystemUtil.getenv("JPI_PLUGIN2_VERBOSE") != null;
    private static final String JPI_VM_OPTIONS = "_JPI_VM_OPTIONS";
    private static final String JAVA_EXT_DIRS = "-Djava.ext.dirs=";
    private static final String TRUSTED_DIR = File.separator + "lib" + File.separator + "trusted";
    private static String javaHome;
    private static volatile boolean getenvSupported;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    public static final int MACOSX = 3;
    private static int osType;
    private static boolean isVista;

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = SystemUtil.getSystemProperty("java.home");
        }
        return javaHome;
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean debug(String string) {
        return SystemUtil.getSystemProperty("sun.plugin2.debug." + string) != null;
    }

    public static String getenv(final String string) {
        if (getenvSupported) {
            try {
                return (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getenv(string);
                    }
                });
            }
            catch (Error error) {
                getenvSupported = false;
            }
        }
        return null;
    }

    private static void computeIsVista() {
        OSVERSIONINFOA oSVERSIONINFOA = OSVERSIONINFOA.create();
        oSVERSIONINFOA.dwOSVersionInfoSize(OSVERSIONINFOA.size());
        if (Windows.GetVersionExA(oSVERSIONINFOA)) {
            isVista = oSVERSIONINFOA.dwPlatformId() == 2 && oSVERSIONINFOA.dwMajorVersion() >= 6;
        }
    }

    public static int getOSType() {
        if (osType == 0) {
            String string = SystemUtil.getSystemProperty("os.name").toLowerCase();
            if (string.startsWith("windows")) {
                osType = 1;
                SystemUtil.computeIsVista();
            } else {
                osType = string.startsWith("mac os x") ? 3 : 2;
            }
        }
        return osType;
    }

    public static boolean isWindowsVista() {
        SystemUtil.getOSType();
        return isVista;
    }

    public static String formatNativeLibraryName(String string) {
        switch (SystemUtil.getOSType()) {
            case 1: {
                return string + ".dll";
            }
            case 2: {
                return "lib" + string + ".so";
            }
            case 3: {
                return "lib" + string + ".jnilib";
            }
        }
        throw new InternalError("Unknown OS type");
    }

    public static String formatExecutableName(String string) {
        if (SystemUtil.getOSType() == 1) {
            return string + ".exe";
        }
        return string;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    private static String getVmArgs(JREInfo jREInfo) {
        String string = SystemUtil.getenv(JPI_VM_OPTIONS);
        if (string != null) {
            return string;
        }
        return jREInfo.getVmArgs();
    }

    public static JVMParameters getDefaultVmArgs(JREInfo jREInfo) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseTrustedOptions(SystemUtil.getVmArgs(jREInfo));
        jVMParameters.setDefault(true);
        return jVMParameters;
    }

    public static JVMParameters extractAppletParamsToJVMParameters(Map map, boolean bl) {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseBootClassPath(JVMParameters.getPlugInDependentJars());
        jVMParameters.addInternalArgument("-Djava.class.path=" + Config.getJREHome() + File.separator + "classes");
        jVMParameters.setDefault(true);
        jVMParameters.parse((String)map.get("java_arguments"), !bl);
        return jVMParameters;
    }

    public static JVMParameters prepareJVMParameter(JVMParameters jVMParameters, JREInfo jREInfo, JVMParameters jVMParameters2) {
        JVMParameters jVMParameters3 = new JVMParameters();
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from deployment.properties");
        }
        jVMParameters3.addArguments(jVMParameters2);
        if (DEBUG && VERBOSE) {
            System.out.println("    JVMManager.createJVMInstance passing along JVM parameters from this applet instance");
        }
        jVMParameters3.addArguments(jVMParameters);
        SystemUtil.addJavaExtDirsOption(jVMParameters3);
        SystemUtil.addXToolkitOption(jVMParameters3, jREInfo.getProductVersion());
        SystemUtil.addUIElementOption(jVMParameters3);
        jVMParameters3.addInternalArgument("-Dsun.awt.warmup=true");
        return jVMParameters3;
    }

    private static void addXToolkitOption(JVMParameters jVMParameters, VersionID versionID) {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("sunos") && new VersionID("1.5*").match(versionID)) {
            jVMParameters.addInternalArgument("-Dawt.toolkit=sun.awt.X11.XToolkit");
        }
    }

    private static void addUIElementOption(JVMParameters jVMParameters) {
        if (SystemUtil.getOSType() == 3) {
            jVMParameters.addInternalArgument("-Dapple.awt.UIElement=true");
        }
    }

    private static void addJavaExtDirsOption(JVMParameters jVMParameters) {
        String string = SystemUtil.getJavaExtDirsProp(jVMParameters);
        if (string != null) {
            jVMParameters.addInternalArgument(string);
        }
    }

    private static String getJavaExtDirsProp(JVMParameters jVMParameters) {
        String string;
        String string2;
        File file;
        boolean bl;
        if (jVMParameters.containsPrefix(JAVA_EXT_DIRS)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(JAVA_EXT_DIRS);
        stringBuffer.append(Config.getJREHome() + File.separator + "lib" + File.separator + "ext");
        String string3 = stringBuffer.toString();
        boolean bl2 = bl = JVMManager.getBrowserType() == 3;
        if (bl && (file = new File(string2 = Config.getInstance().getBrowserHomePath() + File.separator + "jss")).exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        string2 = Config.getSystemHome() + TRUSTED_DIR;
        file = new File(string2);
        if (SystemUtil.getOSType() == 1 && file.exists()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(string2);
        }
        if ((string = stringBuffer.toString()).equals(string3)) {
            return null;
        }
        return string;
    }

    static {
        getenvSupported = true;
    }
}

