/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.JOptionPane;
import productinstaller.ConnectionToServer;
import productinstaller.DbManager;
import productinstaller.InstallingPanel;

public class DiscsInstaller {
    private boolean lockCreated = false;
    private String from;
    private String to;
    private InstallingPanel installingPanel;
    private DbManager thisDm;
    private DbManager installPathDm;
    private ConnectionToServer conn;
    private String chapter;
    private boolean installationDone = false;
    private boolean installationSuccessfull = false;
    private String serverAnswer;

    public DiscsInstaller(String from, String to, InstallingPanel installingPanel, String serverAnswer) {
        this.from = from;
        this.to = to;
        this.serverAnswer = serverAnswer;
        this.installingPanel = installingPanel;
        this.thisDm = new DbManager(from + System.getProperty("file.separator", File.separator) + "examen.db");
        this.installPathDm = new DbManager(to + System.getProperty("file.separator", File.separator) + "examen.db");
        try {
            this.installPathDm.getConn().setAutoCommit(false);
        }
        catch (SQLException ex) {
            System.err.println("set Db to NO AUTHOCOMMIT failed");
        }
    }

    public void installDisc() {
        File dbCheckFile = new File(this.to + "examen.db");
        if (!dbCheckFile.exists() || dbCheckFile.length() == 0L) {
            JOptionPane.showMessageDialog(this.installingPanel, "\u0411\u0430\u0437\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0435 \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u0430:\n" + this.to + System.getProperty("file.separator", File.separator) + "examen.db", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            return;
        }
        this.installOneDisc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installOneDisc() {
        try {
            boolean discAlreadyInstalledInDb;
            if (this.thisDm == null) {
                this.thisDm = new DbManager(this.from + System.getProperty("file.separator") + "examen.db");
            }
            ArrayList<Map<String, Object>> data = this.thisDm.getResourcesInfo();
            HashMap<String, String> keywords = this.thisDm.getResourcesKeywords();
            byte[] checkKey = (byte[])this.thisDm.getOneCellValue("status", "products");
            if (this.installPathDm == null) {
                this.installPathDm = new DbManager(this.to + System.getProperty("file.separator") + "examen.db");
                this.installPathDm.getConn().setAutoCommit(false);
            }
            String grade = data.get(0).get("grade").toString();
            String subject = data.get(0).get("subject").toString();
            String chapter = data.get(0).get("chapter").toString();
            String hash = this.getHash(chapter);
            this.chapter = chapter;
            this.installingPanel.setInstallLab(chapter);
            HashMap<String, Integer> idsAndFilenames = this.installPathDm.getIdsAndFilenames();
            HashMap<String, Integer> idsToSwf = this.installPathDm.getSwfsIds(chapter);
            boolean bl = discAlreadyInstalledInDb = !idsToSwf.isEmpty();
            if (discAlreadyInstalledInDb) {
                this.installPathDm.deleteDiscInfo(chapter);
            }
            HashMap<String, Integer> installedNames = new HashMap<String, Integer>();
            int o = 0;
            this.installingPanel.setProgress(0);
            for (Map<String, Object> row : data) {
                grade = row.get("grade").toString();
                subject = row.get("subject").toString();
                String filename = row.get("filename").toString();
                String theme = row.get("theme").toString();
                String lesson = row.get("lesson").toString();
                String themeArr = row.get("theme_arrange").toString();
                String lessonArr = row.get("lesson_arrange").toString();
                int id_resources = Integer.valueOf(row.get("id_resources").toString());
                int answersCount = Integer.valueOf(row.get("answers").toString());
                int resId = -1;
                if (idsToSwf.containsKey(filename)) {
                    resId = idsToSwf.get(filename);
                }
                if (installedNames.containsKey(filename)) {
                    resId = (Integer)installedNames.get(filename);
                }
                if (resId == -1) {
                    resId = this.checkContainsSwf(filename, idsAndFilenames);
                }
                if (resId == -1) {
                    int newId = this.installPathDm.insertResource(this.thisDm.getSwf(id_resources), this.to, filename, hash);
                    this.installPathDm.insertThumb(this.thisDm.getThumb(id_resources), this.to, hash, filename, newId);
                    this.installPathDm.insertResourceInfo(theme, grade, subject, lesson, newId, chapter, answersCount, filename, themeArr, lessonArr);
                    installedNames.put(filename, newId);
                    resId = newId;
                } else {
                    this.installPathDm.updateResource(this.thisDm.getSwf(id_resources), this.to, filename, hash, resId);
                    this.installPathDm.insertThumb(this.thisDm.getThumb(id_resources), this.to, hash, filename, resId);
                    this.installPathDm.insertResourceInfo(theme, grade, subject, lesson, resId, chapter, answersCount, filename, themeArr, lessonArr);
                }
                if (!keywords.isEmpty() && keywords.containsKey(filename)) {
                    String[] keywordsArr = keywords.get(filename).split(",");
                    ArrayList<Integer> keywordsIdsList = new ArrayList<Integer>();
                    for (int i = 0; i < keywordsArr.length; ++i) {
                        String keyword = keywordsArr[i].trim();
                        int keywordId = this.installPathDm.getKeywordId(keyword);
                        if (keywordId == -1) {
                            keywordId = this.installPathDm.setKeyword(keyword);
                        }
                        keywordsIdsList.add(keywordId);
                    }
                    this.installPathDm.setKeywordsToResource(keywordsIdsList, resId);
                }
                this.installingPanel.setProgress(++o * 100 / data.size());
            }
            this.thisDm.connClose();
            this.thisDm = null;
            this.installPathDm.setProductStatus(chapter, checkKey);
            this.installPathDm.changeDiscStatus(grade, chapter, "active", "deleted");
            boolean isActivationPresent = this.isActivationKeyPresent();
            if (!isActivationPresent) {
                this.installPathDm.changeDiscStatus(grade, chapter, "installing", "deactivated");
            } else {
                this.installPathDm.changeDiscStatus(grade, chapter, "installing", "active");
            }
            this.installPathDm.setTreeLastModifiedDate(new Date().getTime());
            this.installPathDm.getConn().commit();
            this.installPathDm.getConn().setAutoCommit(true);
            this.installPathDm.connClose();
            this.installingPanel.setProgress(100);
            if (isActivationPresent) {
                // empty if block
            }
        }
        catch (SQLException ex) {
            try {
                if (this.installPathDm != null) {
                    this.installPathDm.getConn().rollback();
                }
            }
            catch (SQLException ex1) {
                System.out.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0430\u0442\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f");
                Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex1);
            }
            String error = ex.getMessage() + "\n" + ex.getStackTrace();
            JOptionPane.showMessageDialog(this.installingPanel, error);
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (this.thisDm != null) {
                    this.thisDm.connClose();
                    this.thisDm = null;
                }
                if (this.installPathDm != null) {
                    this.installPathDm.connClose();
                    this.installPathDm = null;
                }
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog(this.installingPanel, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.installationSuccessfull = true;
        if (this.installationSuccessfull) {
            ConnectionToServer.connect(this.to).sendRequest("{\"request\":\"installerAddButtonRequest\", \"discName\":\"" + this.chapter + "\", \"discType\":\"\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c\"}");
        }
        this.installationDone = true;
    }

    private String getHash(String s) {
        try {
            byte[] bytesOfMessage = s.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(bytesOfMessage);
            String b1 = new BigInteger(1, thedigest).toString(16);
            return b1;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }

    private int checkContainsSwf(String filename, HashMap<String, Integer> data) {
        if (!data.isEmpty() && data.containsKey(filename)) {
            return data.get(filename);
        }
        return -1;
    }

    private boolean isActivationKeyPresent() {
        try {
            String[] keys = InstallingPanel.prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].startsWith(this.chapter.length() > 80 ? this.chapter.substring(0, 79) : this.chapter)) continue;
                return true;
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

