/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTKeyStroke;
import java.awt.Toolkit;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.motif.MEmbeddedFramePeer;
import sun.awt.motif.MToolkit;

public class MEmbeddedFrame
extends EmbeddedFrame {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.motif.xembed.MEmbeddedFrame");
    long handle;

    public MEmbeddedFrame() {
    }

    public MEmbeddedFrame(long l) {
        this(l, IDKind.WIDGET, false);
    }

    public MEmbeddedFrame(long l, boolean bl) {
        this(l, IDKind.WINDOW, bl);
    }

    public MEmbeddedFrame(long l, IDKind iDKind, boolean bl) {
        super(bl);
        this.handle = iDKind == IDKind.WIDGET ? l : MEmbeddedFrame.getWidget(l);
        MToolkit mToolkit = (MToolkit)Toolkit.getDefaultToolkit();
        this.setPeer(mToolkit.createEmbeddedFrame(this));
        this.addNotify();
        this.show();
    }

    public void synthesizeWindowActivation(boolean bl) {
        MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)this.getPeer();
        if (mEmbeddedFramePeer != null) {
            if (mEmbeddedFramePeer.supportsXEmbed() && mEmbeddedFramePeer.isXEmbedActive()) {
                xembedLog.fine("The method shouldn't be called when XEmbed is active!");
            } else {
                mEmbeddedFramePeer.synthesizeFocusInOut(bl);
            }
        }
    }

    public void show() {
        if (this.handle != 0L) {
            MEmbeddedFrame.mapWidget(this.handle);
        }
        super.show();
    }

    public boolean traverseIn(boolean bl) {
        MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)this.getPeer();
        if (mEmbeddedFramePeer != null) {
            if (mEmbeddedFramePeer.supportsXEmbed() && mEmbeddedFramePeer.isXEmbedActive()) {
                xembedLog.fine("The method shouldn't be called when XEmbed is active!");
            } else {
                return super.traverseIn(bl);
            }
        }
        return false;
    }

    protected boolean traverseOut(boolean bl) {
        MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)this.getPeer();
        mEmbeddedFramePeer.traverseOut(bl);
        return true;
    }

    static native long getWidget(long var0);

    static native int mapWidget(long var0);

    public void registerAccelerator(AWTKeyStroke aWTKeyStroke) {
        MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)this.getPeer();
        if (mEmbeddedFramePeer != null) {
            mEmbeddedFramePeer.registerAccelerator(aWTKeyStroke);
        }
    }

    public void unregisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        MEmbeddedFramePeer mEmbeddedFramePeer = (MEmbeddedFramePeer)this.getPeer();
        if (mEmbeddedFramePeer != null) {
            mEmbeddedFramePeer.unregisterAccelerator(aWTKeyStroke);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IDKind {
        WIDGET,
        WINDOW;

    }
}

