/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import java.util.ArrayList;
import java.util.Vector;

public class PacksPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData automatedInstallData, IXMLElement iXMLElement) {
        for (int i = 0; i < automatedInstallData.availablePacks.size(); ++i) {
            Pack pack = automatedInstallData.availablePacks.get(i);
            XMLElementImpl xMLElementImpl = new XMLElementImpl("pack", iXMLElement);
            xMLElementImpl.setAttribute("index", Integer.toString(i));
            xMLElementImpl.setAttribute("name", pack.name);
            Boolean bl = automatedInstallData.selectedPacks.contains(pack);
            xMLElementImpl.setAttribute("selected", bl.toString());
            iXMLElement.addChild(xMLElementImpl);
        }
    }

    public void runAutomated(AutomatedInstallData automatedInstallData, IXMLElement iXMLElement) {
        final class PInfo {
            private boolean _selected;
            private int _index;
            private String _name = "";

            PInfo(boolean bl, String string, String string2) {
                this._selected = bl;
                try {
                    this._index = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this._index = -100;
                }
                if (string2 != null) {
                    this._name = string2;
                }
            }

            public boolean isSelected() {
                return this._selected;
            }

            public boolean equals(int n) {
                return this._index == n && this._name.equals("");
            }

            public boolean equals(String string) {
                return this._name.equals(string);
            }

            public String toString() {
                String string = "";
                if (!this._name.equals("")) {
                    string = "Name: " + this._name + " and ";
                }
                string = string + "Index: " + String.valueOf(this._index);
                return string;
            }
        }
        ArrayList<PInfo> arrayList = new ArrayList<PInfo>();
        Vector<IXMLElement> vector = iXMLElement.getChildrenNamed("pack");
        System.out.println("Read pack list from xml definition.");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            IXMLElement serializable = vector.get(i);
            String string = serializable.getAttribute("index");
            String string2 = serializable.getAttribute("name");
            String string3 = serializable.getAttribute("selected");
            boolean bl = string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("on");
            PInfo pInfo = new PInfo(bl, string, string2);
            arrayList.add(pInfo);
            System.out.println("Try to " + (bl ? "add to" : "remove from") + " selection [" + pInfo.toString() + "]");
        }
        System.out.println("Modify pack selection.");
        block1: for (Pack pack : automatedInstallData.availablePacks) {
            int n2 = automatedInstallData.availablePacks.indexOf(pack);
            for (PInfo pInfo : arrayList) {
                if (!pInfo.equals(pack.name) && !pInfo.equals(n2)) continue;
                if (pack.required) {
                    if (pInfo.isSelected()) continue block1;
                    System.out.println("Pack [" + pInfo.toString() + "] must be installed because it is required!");
                    continue block1;
                }
                if (pInfo.isSelected()) {
                    if (automatedInstallData.selectedPacks.indexOf(pack) >= 0 || pack.id == null || !automatedInstallData.getRules().canInstallPack(pack.id, automatedInstallData.getVariables())) continue block1;
                    automatedInstallData.selectedPacks.add(pack);
                    System.out.println("Pack [" + pInfo.toString() + "] added to selection.");
                    continue block1;
                }
                automatedInstallData.selectedPacks.remove(pack);
                System.out.println("Pack [" + pInfo.toString() + "] removed from selection.");
                continue block1;
            }
        }
        for (int i = iXMLElement.getChildrenCount(); i > 0; --i) {
            iXMLElement.removeChild(iXMLElement.getChildAtIndex(0));
        }
        this.makeXMLData(automatedInstallData, iXMLElement);
    }
}

