/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class IoHelper {
    private static final String MASKED_SLASH_PLACEHOLDER = "~&_&~";
    private static Properties envVars = null;

    private IoHelper() {
    }

    public static void copyFile(String string, String string2) throws IOException {
        IoHelper.copyFile(new File(string), new File(string2));
    }

    public static void copyFile(File file, File file2) throws IOException {
        IoHelper.copyFile(file, file2, null, null);
    }

    public static void copyFile(File file, File file2, String string) throws IOException {
        IoHelper.copyFile(file, file2, string, null);
    }

    public static void copyFile(File file, File file2, VariableSubstitutor variableSubstitutor) throws IOException {
        IoHelper.copyFile(file, file2, null, variableSubstitutor);
    }

    public static void copyFile(File file, File file2, String string, VariableSubstitutor variableSubstitutor) throws IOException {
        IoHelper.copyFile(file, file2, string, variableSubstitutor, null);
    }

    public static void copyFile(File file, File file2, String string, VariableSubstitutor variableSubstitutor, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        IoHelper.copyStream(fileInputStream, fileOutputStream, variableSubstitutor, string2);
        if (string != null && IoHelper.supported("chmod")) {
            IoHelper.chmod(file2.getAbsolutePath(), string);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, VariableSubstitutor variableSubstitutor, String string) throws IOException {
        if (variableSubstitutor == null) {
            int n;
            byte[] byArray = new byte[5120];
            long l = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
            inputStream.close();
            outputStream.close();
        } else {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 5120);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 5120);
            variableSubstitutor.substitute(bufferedInputStream, bufferedOutputStream, string, null);
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
    }

    public static File copyToTempFile(File file, String string) throws IOException {
        return IoHelper.copyToTempFile(file, string, null);
    }

    public static File copyToTempFile(InputStream inputStream, String string, VariableSubstitutor variableSubstitutor) throws IOException {
        File file = File.createTempFile("izpack_io", string);
        file.deleteOnExit();
        IoHelper.copyStream(inputStream, new FileOutputStream(file), variableSubstitutor, null);
        return file;
    }

    public static File copyToTempFile(File file, String string, VariableSubstitutor variableSubstitutor) throws IOException {
        int n;
        String string2 = file.getCanonicalPath();
        String string3 = string2.substring(n = string2.lastIndexOf(46));
        if (string3 == null) {
            string3 = string;
        }
        File file2 = File.createTempFile("izpack_io", string3);
        file2.deleteOnExit();
        IoHelper.copyFile(file, file2, variableSubstitutor);
        return file2;
    }

    public static File copyToTempFile(String string, String string2) throws IOException {
        return IoHelper.copyToTempFile(new File(string), string2);
    }

    public static void chmod(File file, String string) throws IOException {
        IoHelper.chmod(file.getAbsolutePath(), string);
    }

    public static void chmod(String string, String string2) throws IOException {
        if (!OsVersion.IS_UNIX) {
            throw new IOException("Sorry, chmod not supported yet on " + OsVersion.OS_NAME + ".");
        }
        String[] stringArray = new String[]{"chmod", string2, string};
        String[] stringArray2 = new String[2];
        FileExecutor fileExecutor = new FileExecutor();
        fileExecutor.executeCommand(stringArray, stringArray2);
    }

    public static long getFreeSpace(String string) {
        long l = -1L;
        if (OsVersion.IS_WINDOWS) {
            String string2 = "cmd.exe";
            if (System.getProperty("os.name").toLowerCase().indexOf("windows 9") > -1) {
                return -1L;
            }
            String[] stringArray = new String[]{string2, "/C", "\"dir /D /-C \"" + string + "\"\""};
            String[] stringArray2 = new String[2];
            FileExecutor fileExecutor = new FileExecutor();
            fileExecutor.executeCommand(stringArray, stringArray2);
            l = IoHelper.extractLong(stringArray2[0], -3, 3, "%");
        } else if (OsVersion.IS_SUNOS) {
            String[] stringArray = new String[]{"df", "-k", string};
            String[] stringArray3 = new String[2];
            FileExecutor fileExecutor = new FileExecutor();
            fileExecutor.executeCommand(stringArray, stringArray3);
            l = IoHelper.extractLong(stringArray3[0], -3, 3, "%") * 1024L;
        } else if (OsVersion.IS_HPUX) {
            String[] stringArray = new String[]{"bdf", string};
            String[] stringArray4 = new String[2];
            FileExecutor fileExecutor = new FileExecutor();
            fileExecutor.executeCommand(stringArray, stringArray4);
            l = IoHelper.extractLong(stringArray4[0], -3, 3, "%") * 1024L;
        } else if (OsVersion.IS_UNIX) {
            String[] stringArray = new String[]{"df", "-Pk", string};
            String[] stringArray5 = new String[2];
            FileExecutor fileExecutor = new FileExecutor();
            fileExecutor.executeCommand(stringArray, stringArray5);
            l = IoHelper.extractLong(stringArray5[0], -3, 3, "%") * 1024L;
        }
        return l;
    }

    public static boolean supported(String string) {
        if ("getFreeSpace".equals(string)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
            if (OsVersion.IS_WINDOWS) {
                return System.getProperty("os.name").toLowerCase().indexOf("windows 9") <= -1;
            }
        } else if ("chmod".equals(string)) {
            if (OsVersion.IS_UNIX) {
                return true;
            }
        } else {
            if ("copyFile".equals(string)) {
                return true;
            }
            if ("getPrimaryGroup".equals(string)) {
                if (OsVersion.IS_UNIX) {
                    return true;
                }
            } else {
                if ("getenv".equals(string)) {
                    return true;
                }
                throw new RuntimeException("method name " + string + "not supported by this method");
            }
        }
        return false;
    }

    public static File existingParent(File file) {
        File file2 = file;
        while (!file2.exists()) {
            if (file2.getParent() == null) {
                return file2;
            }
            file2 = file2.getParentFile();
        }
        return file2;
    }

    private static long extractLong(String string, int n, int n2, String string2) {
        int n3;
        long l = -1L;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n4 = stringTokenizer.countTokens();
        int n5 = 0;
        String[] stringArray = new String[n2 + n2];
        for (n3 = 0; n3 < n4 - n2 + n; ++n3) {
            stringTokenizer.nextToken();
        }
        for (n3 = 0; n3 < n2 + n2; ++n3) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringArray[n3] = stringTokenizer.nextToken();
            ++n5;
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (string2 != null && stringArray[n3].indexOf(string2) > -1) continue;
            try {
                l = Long.parseLong(stringArray[n3]);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public static String getPrimaryGroup() {
        if (IoHelper.supported("getPrimaryGroup")) {
            if (OsVersion.IS_SUNOS) {
                StringTokenizer stringTokenizer;
                int n;
                String[] stringArray = new String[]{"id"};
                String[] stringArray2 = new String[2];
                FileExecutor fileExecutor = new FileExecutor();
                fileExecutor.executeCommand(stringArray, stringArray2);
                if (stringArray2[0] != null && (n = (stringTokenizer = new StringTokenizer(stringArray2[0], "()")).countTokens()) >= 4) {
                    for (int i = 0; i < 3; ++i) {
                        stringTokenizer.nextToken();
                    }
                    return stringTokenizer.nextToken();
                }
                return null;
            }
            String[] stringArray = new String[]{"id", "-gn"};
            String[] stringArray3 = new String[2];
            FileExecutor fileExecutor = new FileExecutor();
            fileExecutor.executeCommand(stringArray, stringArray3);
            return stringArray3[0];
        }
        return null;
    }

    public static String replaceString(String string, String string2, String string3) {
        if (string.indexOf(string2) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string.indexOf(string2);
            int n3 = string2.length();
            while (n2 >= 0) {
                if (n2 > 0) {
                    stringBuffer.append(string.substring(n, n2));
                }
                stringBuffer.append(string3);
                n = n2 + n3;
                n2 = string.indexOf(string2, n);
            }
            if (string.length() > n) {
                stringBuffer.append(string.substring(n));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String translatePath(String string, VariableSubstitutor variableSubstitutor) {
        if ((string = variableSubstitutor.substitute(string, null)).indexOf("\\/") >= 0 && string.indexOf(MASKED_SLASH_PLACEHOLDER) < 0) {
            string = IoHelper.replaceString(string, "\\/", MASKED_SLASH_PLACEHOLDER);
            string = string.replace('/', File.separatorChar);
            string = IoHelper.replaceString(string, MASKED_SLASH_PLACEHOLDER, "/");
        } else {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static String getenv(String string) {
        if (envVars == null) {
            IoHelper.loadEnv();
        }
        if (envVars == null) {
            return null;
        }
        if (OsVersion.IS_WINDOWS) {
            string = string.toUpperCase();
        }
        return (String)envVars.get(string);
    }

    private static void loadEnv() {
        String[] stringArray;
        Object object;
        Object object2;
        String[] stringArray2 = new String[2];
        if (OsVersion.IS_WINDOWS) {
            object2 = "cmd.exe";
            if (System.getProperty("os.name").toLowerCase().indexOf("windows 9") > -1) {
                object2 = "command.com";
            }
            object = new String[]{object2, "/C", "set"};
            stringArray = object;
        } else {
            object2 = new String[]{"env"};
            stringArray = object2;
        }
        object2 = new FileExecutor();
        ((FileExecutor)object2).executeCommand(stringArray, stringArray2);
        if (stringArray2[0].length() <= 0) {
            return;
        }
        object = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[0], (String)object);
        envVars = new Properties();
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(61) == -1) {
                if (string == null) {
                    string = (String)object + string2;
                    continue;
                }
                string = string + (String)object + string2;
                continue;
            }
            IoHelper.setEnvVar(string);
            string = string2;
        }
        IoHelper.setEnvVar(string);
    }

    private static void setEnvVar(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(61);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        if (OsVersion.IS_WINDOWS) {
            string2 = string2.toUpperCase();
        }
        envVars.setProperty(string2, string.substring(n + 1));
    }
}

