/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import sun.security.provider.SeedGenerator;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 3581829991155417889L;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest digest;
    private byte[] state;
    private byte[] remainder;
    private int remCount;

    public SecureRandom() {
        this.init(null);
    }

    private SecureRandom(byte[] byArray) {
        this.init(byArray);
    }

    private void init(byte[] byArray) {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        SeedGenerator.generateSeed(byArray);
        return byArray;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        if (this.state != null) {
            this.digest.update(this.state);
            for (int i = 0; i < this.state.length; ++i) {
                this.state[i] = 0;
            }
        }
        this.state = this.digest.digest(byArray);
    }

    private static void updateState(byte[] byArray, byte[] byArray2) {
        int n = 1;
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = byArray[i] + byArray2[i] + n;
            by = (byte)n2;
            bl |= byArray[i] != by;
            byArray[i] = by;
            n = n2 >> 8;
        }
        if (!bl) {
            byArray[0] = (byte)(byArray[0] + 1);
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        byte[] byArray2 = this.remainder;
        if (this.state == null) {
            byte[] byArray3 = new byte[20];
            SeederHolder.seeder.engineNextBytes(byArray3);
            this.state = this.digest.digest(byArray3);
        }
        if ((n3 = this.remCount) > 0) {
            n2 = byArray.length - n4 < 20 - n3 ? byArray.length - n4 : 20 - n3;
            for (n = 0; n < n2; ++n) {
                byArray[n] = byArray2[n3];
                byArray2[n3++] = 0;
            }
            this.remCount += n2;
            n4 += n2;
        }
        while (n4 < byArray.length) {
            this.digest.update(this.state);
            byArray2 = this.digest.digest();
            SecureRandom.updateState(this.state, byArray2);
            n2 = byArray.length - n4 > 20 ? 20 : byArray.length - n4;
            for (n = 0; n < n2; ++n) {
                byArray[n4++] = byArray2[n];
                byArray2[n] = 0;
            }
            this.remCount += n2;
        }
        this.remainder = byArray2;
        this.remCount %= 20;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
    }

    private static class SeederHolder {
        private static final SecureRandom seeder = new SecureRandom(SeedGenerator.getSystemEntropy());

        private SeederHolder() {
        }

        static {
            byte[] byArray = new byte[20];
            SeedGenerator.generateSeed(byArray);
            seeder.engineSetSeed(byArray);
        }
    }
}

