/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import sun.awt.AppContext;
import sun.security.action.GetBooleanAction;
import sun.swing.UIClientPropertyKey;

class AnimationController
implements ActionListener,
PropertyChangeListener {
    private static final boolean VISTA_ANIMATION_DISABLED = AccessController.doPrivileged(new GetBooleanAction("swing.disablevistaanimation"));
    private static final Object ANIMATION_CONTROLLER_KEY = new Object();
    private final Map<JComponent, Map<TMSchema.Part, AnimationState>> animationStateMap = new WeakHashMap<JComponent, Map<TMSchema.Part, AnimationState>>();
    private final Timer timer = new Timer(33, this);

    private static synchronized AnimationController getAnimationController() {
        AppContext appContext = AppContext.getAppContext();
        Object object = appContext.get(ANIMATION_CONTROLLER_KEY);
        if (object == null) {
            object = new AnimationController();
            appContext.put(ANIMATION_CONTROLLER_KEY, object);
        }
        return (AnimationController)object;
    }

    private AnimationController() {
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        UIManager.addPropertyChangeListener(this);
    }

    private static void triggerAnimation(JComponent jComponent, TMSchema.Part part, TMSchema.State state) {
        if (jComponent instanceof JTabbedPane || part == TMSchema.Part.TP_BUTTON) {
            return;
        }
        AnimationController animationController = AnimationController.getAnimationController();
        TMSchema.State state2 = animationController.getState(jComponent, part);
        if (state2 != state) {
            animationController.putState(jComponent, part, state);
            if (state == TMSchema.State.DEFAULTED) {
                state2 = TMSchema.State.HOT;
            }
            if (state2 != null) {
                long l = state == TMSchema.State.DEFAULTED ? 1000L : XPStyle.getXP().getThemeTransitionDuration(jComponent, part, AnimationController.normalizeState(state2), AnimationController.normalizeState(state), TMSchema.Prop.TRANSITIONDURATIONS);
                animationController.startAnimation(jComponent, part, state2, state, l);
            }
        }
    }

    private static TMSchema.State normalizeState(TMSchema.State state) {
        TMSchema.State state2;
        switch (state) {
            case DOWNPRESSED: 
            case LEFTPRESSED: 
            case RIGHTPRESSED: {
                state2 = TMSchema.State.UPPRESSED;
                break;
            }
            case DOWNDISABLED: 
            case LEFTDISABLED: 
            case RIGHTDISABLED: {
                state2 = TMSchema.State.UPDISABLED;
                break;
            }
            case DOWNHOT: 
            case LEFTHOT: 
            case RIGHTHOT: {
                state2 = TMSchema.State.UPHOT;
                break;
            }
            case DOWNNORMAL: 
            case LEFTNORMAL: 
            case RIGHTNORMAL: {
                state2 = TMSchema.State.UPNORMAL;
                break;
            }
            default: {
                state2 = state;
            }
        }
        return state2;
    }

    private synchronized TMSchema.State getState(JComponent jComponent, TMSchema.Part part) {
        TMSchema.State state = null;
        Object object = jComponent.getClientProperty(PartUIClientPropertyKey.getKey(part));
        if (object instanceof TMSchema.State) {
            state = (TMSchema.State)((Object)object);
        }
        return state;
    }

    private synchronized void putState(JComponent jComponent, TMSchema.Part part, TMSchema.State state) {
        jComponent.putClientProperty(PartUIClientPropertyKey.getKey(part), (Object)state);
    }

    private synchronized void startAnimation(JComponent jComponent, TMSchema.Part part, TMSchema.State state, TMSchema.State state2, long l) {
        boolean bl = false;
        if (state2 == TMSchema.State.DEFAULTED) {
            bl = true;
        }
        Map<TMSchema.Part, AnimationState> map = this.animationStateMap.get(jComponent);
        if (l <= 0L) {
            if (map != null) {
                map.remove((Object)part);
                if (map.size() == 0) {
                    this.animationStateMap.remove(jComponent);
                }
            }
            return;
        }
        if (map == null) {
            map = new EnumMap<TMSchema.Part, AnimationState>(TMSchema.Part.class);
            this.animationStateMap.put(jComponent, map);
        }
        map.put(part, new AnimationState(state, l, bl));
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintSkin(JComponent jComponent, XPStyle.Skin skin, Graphics graphics, int n, int n2, int n3, int n4, TMSchema.State state) {
        AnimationController animationController;
        if (VISTA_ANIMATION_DISABLED) {
            skin.paintSkinRaw(graphics, n, n2, n3, n4, state);
            return;
        }
        AnimationController.triggerAnimation(jComponent, skin.part, state);
        AnimationController animationController2 = animationController = AnimationController.getAnimationController();
        synchronized (animationController2) {
            AnimationState animationState = null;
            Map<TMSchema.Part, AnimationState> map = animationController.animationStateMap.get(jComponent);
            if (map != null) {
                animationState = map.get((Object)skin.part);
            }
            if (animationState != null) {
                animationState.paintSkin(skin, graphics, n, n2, n3, n4, state);
            } else {
                skin.paintSkinRaw(graphics, n, n2, n3, n4, state);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lookAndFeel" == propertyChangeEvent.getPropertyName() && !(propertyChangeEvent.getNewValue() instanceof WindowsLookAndFeel)) {
            this.dispose();
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        ArrayList<JComponent> arrayList = null;
        ArrayList<TMSchema.Part> arrayList2 = null;
        for (JComponent jComponent : this.animationStateMap.keySet()) {
            jComponent.repaint();
            if (arrayList2 != null) {
                arrayList2.clear();
            }
            Map<TMSchema.Part, AnimationState> map = this.animationStateMap.get(jComponent);
            if (!jComponent.isShowing() || map == null || map.size() == 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList<JComponent>();
                }
                arrayList.add(jComponent);
                continue;
            }
            for (TMSchema.Part part : map.keySet()) {
                if (!map.get((Object)part).isDone()) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<TMSchema.Part>();
                }
                arrayList2.add(part);
            }
            if (arrayList2 == null) continue;
            if (arrayList2.size() == map.size()) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(jComponent);
                continue;
            }
            for (TMSchema.Part part : arrayList2) {
                map.remove((Object)part);
            }
        }
        if (arrayList != null) {
            for (JComponent jComponent : arrayList) {
                this.animationStateMap.remove(jComponent);
            }
        }
        if (this.animationStateMap.size() == 0) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispose() {
        this.timer.stop();
        UIManager.removePropertyChangeListener(this);
        Class<AnimationController> clazz = AnimationController.class;
        synchronized (AnimationController.class) {
            AppContext.getAppContext().put(ANIMATION_CONTROLLER_KEY, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class AnimationState {
        private final TMSchema.State startState;
        private final long duration;
        private long startTime;
        private boolean isForward = true;
        private boolean isForwardAndReverse;
        private float progress;

        AnimationState(TMSchema.State state, long l, boolean bl) {
            assert (state != null && l > 0L);
            assert (SwingUtilities.isEventDispatchThread());
            this.startState = state;
            this.duration = l * 1000000L;
            this.startTime = System.nanoTime();
            this.isForwardAndReverse = bl;
            this.progress = 0.0f;
        }

        private void updateProgress() {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.isDone()) {
                return;
            }
            long l = System.nanoTime();
            this.progress = (float)(l - this.startTime) / (float)this.duration;
            this.progress = Math.max(this.progress, 0.0f);
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
                if (this.isForwardAndReverse) {
                    this.startTime = l;
                    this.progress = 0.0f;
                    this.isForward = !this.isForward;
                }
            }
        }

        void paintSkin(XPStyle.Skin skin, Graphics graphics, int n, int n2, int n3, int n4, TMSchema.State state) {
            assert (SwingUtilities.isEventDispatchThread());
            this.updateProgress();
            if (!this.isDone()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                skin.paintSkinRaw(graphics2D, n, n2, n3, n4, this.startState);
                float f = this.isForward ? this.progress : 1.0f - this.progress;
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
                skin.paintSkinRaw(graphics2D, n, n2, n3, n4, state);
                graphics2D.dispose();
            } else {
                skin.paintSkinRaw(graphics, n, n2, n3, n4, state);
            }
        }

        boolean isDone() {
            assert (SwingUtilities.isEventDispatchThread());
            return this.progress >= 1.0f;
        }
    }

    private static class PartUIClientPropertyKey
    implements UIClientPropertyKey {
        private static final Map<TMSchema.Part, PartUIClientPropertyKey> map = new EnumMap<TMSchema.Part, PartUIClientPropertyKey>(TMSchema.Part.class);
        private final TMSchema.Part part;

        static synchronized PartUIClientPropertyKey getKey(TMSchema.Part part) {
            PartUIClientPropertyKey partUIClientPropertyKey = map.get((Object)part);
            if (partUIClientPropertyKey == null) {
                partUIClientPropertyKey = new PartUIClientPropertyKey(part);
                map.put(part, partUIClientPropertyKey);
            }
            return partUIClientPropertyKey;
        }

        private PartUIClientPropertyKey(TMSchema.Part part) {
            this.part = part;
        }

        public String toString() {
            return this.part.toString();
        }
    }
}

