/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import productinstaller.DiscsInstaller;

public class ConnectionToServer {
    private Socket socket;
    private DataInputStream din;
    private DataOutputStream dout;
    private int port = this.getPort();
    private String pathTo;
    private static ConnectionToServer connectionToServer = null;

    private ConnectionToServer(String pathTo) {
        this.pathTo = pathTo;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            this.socket = new Socket(ip, this.port);
            this.socket.setSoTimeout(2000);
            this.din = new DataInputStream(this.socket.getInputStream());
            this.dout = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (ConnectException ex) {
        }
        catch (SocketTimeoutException ex) {
        }
        catch (UnknownHostException ex) {
        }
        catch (IOException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ConnectionToServer connect(String pathTo) {
        if (connectionToServer == null) {
            connectionToServer = new ConnectionToServer(pathTo);
        }
        return connectionToServer;
    }

    public void sendRequest(String request) {
        try {
            this.dout.write(this.getMessageBytes(request));
            this.dout.close();
            connectionToServer = null;
        }
        catch (IOException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getMessageBytes(String message) throws Exception {
        int messageType = 1;
        byte[] messageBytes = message.getBytes("UTF8");
        byte[] finalMessage = this.addInfoBytes(messageBytes, messageType);
        return finalMessage;
    }

    public byte[] addInfoBytes(byte[] bytes, int messageType) {
        System.gc();
        byte[] messageBytes = bytes;
        byte[] messageLength = ByteBuffer.allocate(4).putInt(messageBytes.length).array();
        byte[] dataType = ByteBuffer.allocate(4).putInt(messageType).array();
        byte[] finalMessage = new byte[messageBytes.length + 8];
        System.arraycopy(messageLength, 0, finalMessage, 0, 4);
        System.arraycopy(dataType, 0, finalMessage, 4, 4);
        System.arraycopy(messageBytes, 0, finalMessage, 8, messageBytes.length);
        return finalMessage;
    }

    public String loginToServer() {
        try {
            String request = "{\"request\":\"installerLogin\"}";
            this.dout.write(this.getMessageBytes(request));
            String answer = this.din.readUTF();
            this.dout.close();
            connectionToServer = null;
            return answer;
        }
        catch (IOException ex) {
            return "null";
        }
        catch (Exception ex) {
            return "null";
        }
    }

    private int getPort() {
        Properties serverProps = new Properties();
        int port = 3000;
        try {
            File propsFile = new File(this.pathTo + File.separator + "server.properties");
            if (!propsFile.exists()) {
                return port;
            }
            serverProps.load(new FileInputStream(propsFile));
            port = Integer.valueOf(serverProps.get("port").toString());
        }
        catch (IOException ex) {
            Logger.getLogger(DiscsInstaller.class.getName()).log(Level.SEVERE, null, ex);
            return 3000;
        }
        return port;
    }
}

