/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpParams;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduFactoryBER;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpPeer
implements Serializable {
    public static final int defaultSnmpRequestPktSize = 2048;
    public static final int defaultSnmpResponsePktSize = 8192;
    private int maxVarBindLimit = 25;
    private int portNum = 161;
    private int maxTries = 3;
    private int timeout = 3000;
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private long _maxrtt;
    private long _minrtt;
    private long _avgrtt;
    private SnmpParams _snmpParameter = new SnmpParameters();
    private InetAddress _devAddr = null;
    private int maxSnmpPacketSize = 2048;
    InetAddress[] _devAddrList = null;
    int _addrIndex = 0;
    private boolean customPduFactory = false;

    public SnmpPeer(String string) throws UnknownHostException {
        this(string, 161);
    }

    public SnmpPeer(InetAddress inetAddress, int n) {
        this._devAddr = inetAddress;
        this.portNum = n;
    }

    public SnmpPeer(InetAddress inetAddress) {
        this._devAddr = inetAddress;
    }

    public SnmpPeer(String string, int n) throws UnknownHostException {
        this.useIPAddress(string);
        this.portNum = n;
    }

    public final synchronized void useIPAddress(String string) throws UnknownHostException {
        this._devAddr = InetAddress.getByName(string);
    }

    public final synchronized String ipAddressInUse() {
        byte[] byArray = this._devAddr.getAddress();
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public final synchronized void useAddressList(InetAddress[] inetAddressArray) {
        this._devAddrList = inetAddressArray;
        this._addrIndex = 0;
        this.useNextAddress();
    }

    public final synchronized void useNextAddress() {
        if (this._devAddrList == null) {
            return;
        }
        if (this._addrIndex > this._devAddrList.length - 1) {
            this._addrIndex = 0;
        }
        this._devAddr = this._devAddrList[this._addrIndex++];
    }

    public boolean allowSnmpSets() {
        return this._snmpParameter.allowSnmpSets();
    }

    public final InetAddress[] getDestAddrList() {
        return this._devAddrList;
    }

    public final InetAddress getDestAddr() {
        return this._devAddr;
    }

    public final int getDestPort() {
        return this.portNum;
    }

    public final synchronized void setDestPort(int n) {
        this.portNum = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = n;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = n;
    }

    public final String getDevName() {
        return this.getDestAddr().getHostName();
    }

    public String toString() {
        return "Peer/Port : " + this.getDestAddr().getHostAddress() + "/" + this.getDestPort();
    }

    public final synchronized int getVarBindLimit() {
        return this.maxVarBindLimit;
    }

    public final synchronized void setVarBindLimit(int n) {
        this.maxVarBindLimit = n;
    }

    public void setParams(SnmpParams snmpParams) {
        this._snmpParameter = snmpParams;
    }

    public SnmpParams getParams() {
        return this._snmpParameter;
    }

    public final int getMaxSnmpPktSize() {
        return this.maxSnmpPacketSize;
    }

    public final synchronized void setMaxSnmpPktSize(int n) {
        this.maxSnmpPacketSize = n;
    }

    boolean isCustomPduFactory() {
        return this.customPduFactory;
    }

    public void finalize() {
        this._devAddr = null;
        this._devAddrList = null;
        this._snmpParameter = null;
    }

    public long getMinRtt() {
        return this._minrtt;
    }

    public long getMaxRtt() {
        return this._maxrtt;
    }

    public long getAvgRtt() {
        return this._avgrtt;
    }

    private void updateRttStats(long l) {
        if (this._minrtt > l) {
            this._minrtt = l;
        } else if (this._maxrtt < l) {
            this._maxrtt = l;
        } else {
            this._avgrtt = l;
        }
    }
}

