/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class LineNumberFilter
extends XMLFilterImpl {
    private Queue<Integer> lnQueue;
    private Locator locator;

    public LineNumberFilter(XMLReader xMLReader) {
        super(xMLReader);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.lnQueue = new LinkedList<Integer>();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        this.lnQueue.add(this.locator.getLineNumber());
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    private Element getFirstFoundElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private Element getNextSibling(Node node) {
        return this.getFirstFoundElement(node.getNextSibling());
    }

    private Element getFirstChild(Node node) {
        return this.getFirstFoundElement(node.getFirstChild());
    }

    private boolean hasChildElements(Node node) {
        return this.getFirstChild(node) != null;
    }

    private void applyLN(Element element) {
        element.setUserData("ln", this.lnQueue.poll(), null);
    }

    public void applyLN(DOMResult dOMResult) {
        Element element = this.getFirstChild(dOMResult.getNode());
        boolean bl = false;
        Stack<Element> stack = new Stack<Element>();
        while (!bl) {
            if (this.hasChildElements(element)) {
                stack.push(element);
                this.applyLN(element);
                element = this.getFirstChild(element);
                continue;
            }
            this.applyLN(element);
            Element element2 = this.getNextSibling(element);
            if (element2 != null) {
                element = element2;
                continue;
            }
            do {
                if (stack.isEmpty()) {
                    bl = true;
                    continue;
                }
                element = (Element)stack.pop();
                element = this.getNextSibling(element);
            } while (!bl && element == null);
        }
    }
}

