/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PacksPanelBase;
import com.izforge.izpack.util.IoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;

public class ImgPacksPanel
extends PacksPanelBase {
    private static final long serialVersionUID = 3977858492633659444L;
    private HashMap<String, ImageIcon> images;
    private JLabel imgLabel;

    public ImgPacksPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
    }

    protected void createNormalLayout() {
        JScrollPane jScrollPane;
        this.preLoadImages();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.parent.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.25, 0.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.createLabel("PacksPanel.info", "preferences", gridBagLayout, gridBagConstraints);
        this.parent.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 0.5, 0.0);
        this.createLabel("ImgPacksPanel.snap", "tip", gridBagLayout, gridBagConstraints);
        this.tableScroller = new JScrollPane();
        this.parent.buildConstraints(gridBagConstraints, 0, 1, 1, 2, 0.5, 0.0);
        gridBagConstraints.fill = 1;
        this.packsTable = this.createPacksTable(250, this.tableScroller, gridBagLayout, gridBagConstraints);
        Iterator iterator = this.idata.availablePacks.iterator();
        Pack pack = null;
        boolean bl = false;
        while (!bl && iterator.hasNext()) {
            pack = (Pack)iterator.next();
            bl = pack.packImgId != null;
        }
        this.imgLabel = bl ? new JLabel(this.images.get(pack.packImgId)) : new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane(this.imgLabel);
        jScrollPane2.setPreferredSize(this.getPreferredSizeFromImages());
        this.parent.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0.5, 1.0);
        gridBagLayout.addLayoutComponent(jScrollPane2, gridBagConstraints);
        this.add(jScrollPane2);
        Component component = Box.createVerticalStrut(20);
        this.parent.buildConstraints(gridBagConstraints, 1, 2, 1, 3, 0.0, 0.0);
        gridBagLayout.addLayoutComponent(component, gridBagConstraints);
        this.add(component);
        if (this.dependenciesExist) {
            jScrollPane = new JScrollPane();
            jScrollPane.setPreferredSize(new Dimension(250, 40));
            this.parent.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.5, 0.5);
            this.dependencyArea = this.createTextArea("ImgPacksPanel.dependencyList", jScrollPane, gridBagLayout, gridBagConstraints);
        }
        jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(200, 60));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.parent.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 0.5, 0.5);
        this.descriptionArea = this.createTextArea("PacksPanel.description", jScrollPane, gridBagLayout, gridBagConstraints);
        this.parent.buildConstraints(gridBagConstraints, 0, 4, 2, 1, 0.0, 0.0);
        this.createLabel("PacksPanel.tip", "tip", gridBagLayout, gridBagConstraints);
        this.parent.buildConstraints(gridBagConstraints, 0, 5, 2, 1, 0.0, 0.0);
        this.spaceLabel = this.createPanelWithLabel("PacksPanel.space", gridBagLayout, gridBagConstraints);
        if (IoHelper.supported("getFreeSpace")) {
            this.parent.buildConstraints(gridBagConstraints, 0, 6, 2, 1, 0.0, 0.0);
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", gridBagLayout, gridBagConstraints);
        }
    }

    private void preLoadImages() {
        int n = this.idata.availablePacks.size();
        this.images = new HashMap(n);
        for (Pack pack : this.idata.availablePacks) {
            if (pack.packImgId == null) continue;
            try {
                URL uRL = ResourceManager.getInstance().getURL(pack.packImgId);
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.images.put(pack.packImgId, imageIcon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Dimension getPreferredSizeFromImages() {
        int n = 80;
        int n2 = 60;
        Iterator<ImageIcon> iterator = this.images.values().iterator();
        while (iterator.hasNext()) {
            ImageIcon imageIcon;
            ImageIcon imageIcon2 = imageIcon = iterator.next();
            n = Math.max(n, imageIcon2.getIconWidth());
            n2 = Math.max(n2, imageIcon2.getIconHeight());
        }
        n = Math.min(n + 20, this.idata.guiPrefs.width - 150);
        n2 = Math.min(n2 + 20, this.idata.guiPrefs.height - 150);
        return new Dimension(n, n2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.packsTable.getSelectedRow();
        super.valueChanged(listSelectionEvent);
        if (n < 0) {
            return;
        }
        if (n >= 0) {
            Pack pack = (Pack)this.idata.availablePacks.get(n);
            this.imgLabel.setIcon(this.images.get(pack.packImgId));
        }
    }
}

