/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sun.org.mozilla.javascript.internal.BaseFunction;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.MemberBox;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Undefined;

public class FunctionObject
extends BaseFunction {
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    public static final int JAVA_UNSUPPORTED_TYPE = 0;
    public static final int JAVA_STRING_TYPE = 1;
    public static final int JAVA_INT_TYPE = 2;
    public static final int JAVA_BOOLEAN_TYPE = 3;
    public static final int JAVA_DOUBLE_TYPE = 4;
    public static final int JAVA_SCRIPTABLE_TYPE = 5;
    public static final int JAVA_OBJECT_TYPE = 6;
    MemberBox member;
    private String functionName;
    private transient byte[] typeTags;
    private int parmsLength;
    private transient boolean hasVoidReturn;
    private transient int returnTypeTag;
    private boolean isStatic;

    public FunctionObject(String string, Member member, Scriptable scriptable) {
        if (member instanceof Constructor) {
            this.member = new MemberBox((Constructor)member);
            this.isStatic = true;
        } else {
            this.member = new MemberBox((Method)member);
            this.isStatic = this.member.isStatic();
        }
        String string2 = this.member.getName();
        this.functionName = string;
        Class[] classArray = this.member.argTypes;
        int n = classArray.length;
        if (n == 4 && (classArray[1].isArray() || classArray[2].isArray())) {
            if (classArray[1].isArray()) {
                if (!this.isStatic || classArray[0] != ScriptRuntime.ContextClass || classArray[1].getComponentType() != ScriptRuntime.ObjectClass || classArray[2] != ScriptRuntime.FunctionClass || classArray[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", string2);
                }
                this.parmsLength = -2;
            } else {
                if (!this.isStatic || classArray[0] != ScriptRuntime.ContextClass || classArray[1] != ScriptRuntime.ScriptableClass || classArray[2].getComponentType() != ScriptRuntime.ObjectClass || classArray[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", string2);
                }
                this.parmsLength = -1;
            }
        } else {
            this.parmsLength = n;
            if (n > 0) {
                this.typeTags = new byte[n];
                for (int i = 0; i != n; ++i) {
                    int n2 = FunctionObject.getTypeTag(classArray[i]);
                    if (n2 == 0) {
                        throw Context.reportRuntimeError2("msg.bad.parms", classArray[i].getName(), string2);
                    }
                    this.typeTags[i] = (byte)n2;
                }
            }
        }
        if (this.member.isMethod()) {
            Method method = this.member.method();
            Class<?> clazz = method.getReturnType();
            if (clazz == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(clazz);
            }
        } else {
            Class clazz = this.member.getDeclaringClass();
            if (!ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
                throw Context.reportRuntimeError1("msg.bad.ctor.return", clazz.getName());
            }
        }
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
    }

    public static int getTypeTag(Class clazz) {
        if (clazz == ScriptRuntime.StringClass) {
            return 1;
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            return 2;
        }
        if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
            return 3;
        }
        if (clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return 4;
        }
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return 5;
        }
        if (clazz == ScriptRuntime.ObjectClass) {
            return 6;
        }
        return 0;
    }

    public static Object convertArg(Context context, Scriptable scriptable, Object object, int n) {
        switch (n) {
            case 1: {
                if (object instanceof String) {
                    return object;
                }
                return ScriptRuntime.toString(object);
            }
            case 2: {
                if (object instanceof Integer) {
                    return object;
                }
                return new Integer(ScriptRuntime.toInt32(object));
            }
            case 3: {
                if (object instanceof Boolean) {
                    return object;
                }
                return ScriptRuntime.toBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                if (object instanceof Double) {
                    return object;
                }
                return new Double(ScriptRuntime.toNumber(object));
            }
            case 5: {
                if (object instanceof Scriptable) {
                    return object;
                }
                return ScriptRuntime.toObject(context, scriptable, object);
            }
            case 6: {
                return object;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getArity() {
        return this.parmsLength < 0 ? 1 : this.parmsLength;
    }

    public int getLength() {
        return this.getArity();
    }

    public String getFunctionName() {
        return this.functionName == null ? "" : this.functionName;
    }

    public Member getMethodOrConstructor() {
        if (this.member.isMethod()) {
            return this.member.method();
        }
        return this.member.ctor();
    }

    static Method findSingleMethod(Method[] methodArray, String string) {
        Method method = null;
        int n = methodArray.length;
        for (int i = 0; i != n; ++i) {
            Method method2 = methodArray[i];
            if (method2 == null || !string.equals(method2.getName())) continue;
            if (method != null) {
                throw Context.reportRuntimeError2("msg.no.overload", string, method2.getDeclaringClass().getName());
            }
            method = method2;
        }
        return method;
    }

    static Method[] getMethodList(Class clazz) {
        Method[] methodArray = null;
        try {
            if (!sawSecurityException) {
                methodArray = clazz.getDeclaredMethods();
            }
        }
        catch (SecurityException securityException) {
            sawSecurityException = true;
        }
        if (methodArray == null) {
            methodArray = clazz.getMethods();
        }
        int n = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (sawSecurityException ? methodArray[i].getDeclaringClass() != clazz : !Modifier.isPublic(methodArray[i].getModifiers())) {
                methodArray[i] = null;
                continue;
            }
            ++n;
        }
        Method[] methodArray2 = new Method[n];
        int n2 = 0;
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i] == null) continue;
            methodArray2[n2++] = methodArray[i];
        }
        return methodArray2;
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        ScriptRuntime.setFunctionProtoAndParent(this, scriptable);
        this.setImmunePrototypeProperty(scriptable2);
        scriptable2.setParentScope(this);
        FunctionObject.defineProperty(scriptable2, "constructor", this, 7);
        String string = scriptable2.getClassName();
        FunctionObject.defineProperty(scriptable, string, this, 2);
        this.setParentScope(scriptable);
    }

    public static Object convertArg(Context context, Scriptable scriptable, Object object, Class clazz) {
        int n = FunctionObject.getTypeTag(clazz);
        if (n == 0) {
            throw Context.reportRuntimeError1("msg.cant.convert", clazz.getName());
        }
        return FunctionObject.convertArg(context, scriptable, object, n);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable object, Object[] objectArray) {
        Object object2;
        boolean bl = false;
        if (this.parmsLength < 0) {
            if (this.parmsLength == -1) {
                Object[] objectArray2 = new Object[]{context, object, objectArray, this};
                object2 = this.member.invoke(null, objectArray2);
                bl = true;
            } else {
                boolean bl2 = object == null;
                Boolean bl3 = bl2 ? Boolean.TRUE : Boolean.FALSE;
                Object[] objectArray3 = new Object[]{context, objectArray, this, bl3};
                object2 = this.member.isCtor() ? this.member.newInstance(objectArray3) : this.member.invoke(null, objectArray3);
            }
        } else {
            Object object3;
            int n;
            Object[] objectArray4;
            if (!this.isStatic && !(objectArray4 = this.member.getDeclaringClass()).isInstance(object)) {
                n = 0;
                if (object == scriptable && scriptable != (object3 = this.getParentScope()) && (n = (int)(objectArray4.isInstance(object3) ? 1 : 0)) != 0) {
                    object = object3;
                }
                if (n == 0) {
                    throw ScriptRuntime.typeError1("msg.incompat.call", this.functionName);
                }
            }
            if (this.parmsLength == objectArray.length) {
                objectArray4 = objectArray;
                for (n = 0; n != this.parmsLength; ++n) {
                    object3 = objectArray[n];
                    Object object4 = FunctionObject.convertArg(context, scriptable, object3, this.typeTags[n]);
                    if (object3 == object4) continue;
                    if (objectArray4 == objectArray) {
                        objectArray4 = (Object[])objectArray.clone();
                    }
                    objectArray4[n] = object4;
                }
            } else if (this.parmsLength == 0) {
                objectArray4 = ScriptRuntime.emptyArgs;
            } else {
                objectArray4 = new Object[this.parmsLength];
                for (n = 0; n != this.parmsLength; ++n) {
                    object3 = n < objectArray.length ? objectArray[n] : Undefined.instance;
                    objectArray4[n] = FunctionObject.convertArg(context, scriptable, object3, this.typeTags[n]);
                }
            }
            if (this.member.isMethod()) {
                object2 = this.member.invoke(object, objectArray4);
                bl = true;
            } else {
                object2 = this.member.newInstance(objectArray4);
            }
        }
        if (bl) {
            if (this.hasVoidReturn) {
                object2 = Undefined.instance;
            } else if (this.returnTypeTag == 0) {
                object2 = context.getWrapFactory().wrap(context, scriptable, object2, null);
            }
        }
        return object2;
    }

    public Scriptable createObject(Context context, Scriptable scriptable) {
        Scriptable scriptable2;
        if (this.member.isCtor() || this.parmsLength == -2) {
            return null;
        }
        try {
            scriptable2 = (Scriptable)this.member.getDeclaringClass().newInstance();
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        scriptable2.setPrototype(this.getClassPrototype());
        scriptable2.setParentScope(this.getParentScope());
        return scriptable2;
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        if (this.parmsLength > 0) {
            object = this.member.argTypes;
            this.typeTags = new byte[this.parmsLength];
            for (int i = 0; i != this.parmsLength; ++i) {
                this.typeTags[i] = (byte)FunctionObject.getTypeTag((Class)object[i]);
            }
        }
        if (this.member.isMethod()) {
            object = this.member.method();
            Class<?> clazz = ((Method)object).getReturnType();
            if (clazz == Void.TYPE) {
                this.hasVoidReturn = true;
            } else {
                this.returnTypeTag = FunctionObject.getTypeTag(clazz);
            }
        }
    }
}

