/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import productinstaller.ProductInstaller;

public class DbManager {
    private Connection conn;

    public DbManager(String dbName) {
        try {
            String driver = "org.sqlite.JDBC";
            Class.forName(driver);
            File bdFile = new File(dbName);
            if (!bdFile.exists() || bdFile.length() == 0L) {
                String classPath = System.getProperty("java.class.path");
                dbName = classPath.substring(0, classPath.lastIndexOf(File.separatorChar)) + System.getProperty("file.separator") + dbName;
                bdFile = new File(dbName);
                bdFile = null;
            }
            this.conn = DriverManager.getConnection("jdbc:sqlite:" + dbName);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(ProductInstaller.mainLink, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f \u043a \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0443. \u0412\u0435\u0440\u043e\u044f\u0442\u043d\u043e, \u0434\u0440\u0430\u0439\u0432\u0435\u0440 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u0437\u0430\u043d\u044f\u0442 \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u043c.");
        }
    }

    private void createNewProjectDb() {
        String sql = "CREATE TABLE IF NOT EXISTS resources_info (id INTEGER PRIMARY KEY AUTOINCREMENT, chapter TEXT,  theme TEXT,  id_resources INTEGER,  grade TEXT,  subject TEXT, lesson TEXT)";
        String sql2 = "CREATE TABLE IF NOT EXISTS resources (id INTEGER PRIMARY KEY AUTOINCREMENT, data BLOB)";
        String sql3 = "CREATE TABLE IF NOT EXISTS thumbs (id INTEGER PRIMARY KEY AUTOINCREMENT, id_resources INTEGER, thumb BLOB)";
        try {
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.executeUpdate();
            PreparedStatement st2 = this.conn.prepareStatement(sql2);
            st2.executeUpdate();
            PreparedStatement st3 = this.conn.prepareStatement(sql3);
            st3.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setPragma(String sql) {
        try {
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.executeQuery();
            st.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setPragma2(String sql) {
        try {
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.executeUpdate();
            st.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean containsDisc(String grade, String subject, String chapter) throws SQLException {
        String sql = "SELECT grade,subject FROM resources_info WHERE grade=? AND subject=? AND chapter=? AND active=? LIMIT 1";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, grade);
        st.setString(2, subject);
        st.setString(3, chapter);
        st.setString(4, "active");
        ResultSet rs = st.executeQuery();
        if (rs.next()) {
            st.close();
            return true;
        }
        st.close();
        return false;
    }

    public void insertResourceInfo(String theme, String grade, String subject, String lesson, int id_resources, String chapter, int answers, String filename, String themeArr, String lessonArr) {
        try {
            String sql = "INSERT INTO resources_info (theme,grade,subject,lesson,id_resources,chapter,answers_count,filename,active,theme_arrange,lesson_arrange) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setString(1, theme);
            st.setString(2, grade);
            st.setString(3, subject);
            st.setString(4, lesson);
            st.setInt(5, id_resources);
            st.setString(6, chapter);
            st.setInt(7, answers);
            st.setString(8, filename);
            st.setString(9, "installing");
            st.setString(10, themeArr);
            st.setString(11, lessonArr);
            st.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ArrayList<Map<String, Object>> getResources() throws SQLException {
        String sql = "SELECT * FROM resources";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("data", rs.getBytes("data"));
            row.put("id", rs.getInt("id"));
            data.add(row);
        }
        return data;
    }

    public ArrayList<Map<String, Object>> getAllResources() throws SQLException {
        String sql = "SELECT resources.data,resources_info.chapter, resources_info.theme, resources_info.grade, resources_info.subject, resources_info.lesson, resources_info.filename, resources_info.answers_count, resources_info.theme_arrange, resources_info.lesson_arrange, thumbs.thumb FROM resources JOIN resources_info ON resources.id=resources_info.id_resources JOIN thumbs ON thumbs.id_resources=resources.id ";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("data", rs.getBytes("data"));
            row.put("chapter", rs.getString("chapter"));
            row.put("theme", rs.getString("theme"));
            row.put("grade", rs.getString("grade"));
            row.put("subject", rs.getString("subject"));
            row.put("lesson", rs.getString("lesson"));
            row.put("thumb", rs.getBytes("thumb"));
            row.put("filename", rs.getString("filename"));
            row.put("answers", rs.getString("answers_count"));
            row.put("theme_arrange", rs.getString("theme_arrange"));
            row.put("lesson_arrange", rs.getString("lesson_arrange"));
            data.add(row);
        }
        return data;
    }

    public ArrayList<Map<String, Object>> getResourcesInfo() throws SQLException {
        String sql = "SELECT * FROM resources_info";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id_resources", rs.getString("id_resources"));
            row.put("chapter", rs.getString("chapter"));
            row.put("theme", rs.getString("theme"));
            row.put("grade", rs.getString("grade"));
            row.put("subject", rs.getString("subject"));
            row.put("lesson", rs.getString("lesson"));
            row.put("filename", rs.getString("filename"));
            row.put("answers", rs.getString("answers_count"));
            row.put("theme_arrange", rs.getString("theme_arrange"));
            row.put("lesson_arrange", rs.getString("lesson_arrange"));
            data.add(row);
        }
        return data;
    }

    public HashMap<String, String> getResourcesKeywords() throws SQLException {
        String sql = "SELECT * FROM keywords";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        HashMap<String, String> keywords = new HashMap<String, String>();
        while (rs.next()) {
            String filename = rs.getString("filenames");
            String keywordsStr = rs.getString("keyword");
            keywords.put(filename, keywordsStr);
        }
        st.close();
        return keywords;
    }

    public int insertResource(Object res, String filename) throws SQLException {
        int id = -1;
        String sql = "INSERT INTO resources (data,filename) values (?,?)";
        int s = 0;
        byte[] bytes = (byte[])res;
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setBytes(1, bytes);
        st.setString(2, filename);
        s = st.executeUpdate();
        if (s > 0) {
            // empty if block
        }
        st.close();
        String sql2 = "SELECT MAX(id) FROM resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        id = rs2.next() ? rs2.getInt(1) : -1;
        return id;
    }

    public int insertResource(Object res, String path, String filename, String hash) throws SQLException {
        int id = -1;
        byte[] bytes = (byte[])res;
        String sql = "INSERT INTO resources (filename,hash) values (?,?)";
        int s = 0;
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, filename);
        st.setString(2, hash);
        s = st.executeUpdate();
        if (s > 0) {
            // empty if block
        }
        st.close();
        String sql2 = "SELECT MAX(id) FROM resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        id = rs2.next() ? rs2.getInt(1) : -1;
        File dir = new File(path + File.separator + "bin" + File.separator + hash + File.separator + id);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, filename);
        try {
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(bytes);
            fout.close();
            bytes = null;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return id;
    }

    public void insertThumb(Object res, String path, String hash, String filename, int resources_id) throws SQLException {
        byte[] bytes = (byte[])res;
        File dir = new File(path + File.separator + "bin" + File.separator + hash + File.separator + resources_id);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, filename + ".t");
        try {
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(bytes);
            fout.close();
            bytes = null;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void connClose() throws SQLException {
        this.conn.close();
    }

    public void executeSQL(String sql) throws SQLException {
        Statement stmt = this.conn.createStatement();
        stmt.execute(sql);
        stmt.close();
    }

    public int checkLogin(String login, String pass) throws SQLException {
        String sql = "SELECT id FROM users WHERE login=? AND pass=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, login.trim());
        st.setString(2, pass.trim());
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt(1) : -1;
        rs.close();
        st.close();
        return id;
    }

    public int checkServerLogin(String login, String pass) throws SQLException {
        String sql = "SELECT id FROM users WHERE login=? AND pass=? AND type!='student'";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, login.trim());
        st.setString(2, pass.trim());
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt(1) : -1;
        rs.close();
        st.close();
        return id;
    }

    public int getAdminId() throws SQLException {
        Statement st = this.conn.createStatement();
        String sql1 = "SELECT id FROM users WHERE type='admin'";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int adminId = rs1.getInt("id");
        return adminId;
    }

    public String getUserData(String data, int id) throws SQLException {
        String sql = "SELECT " + data + " FROM users WHERE id=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setInt(1, id);
        ResultSet rs = st.executeQuery();
        String userData = rs.next() ? rs.getString(1) : null;
        return userData;
    }

    public Object[][] getAllUsers() throws SQLException {
        String sql1 = "SELECT COUNT(*) FROM users";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int rows = rs1.next() ? rs1.getInt(1) : 0;
        String sql2 = "SELECT * FROM users";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        ResultSetMetaData metaData = rs2.getMetaData();
        int cols = metaData.getColumnCount();
        Object[][] usersData = new Object[rows][cols];
        for (int i = 1; i <= rows; ++i) {
            rs2.next();
            usersData[i - 1][0] = rs2.getObject("id");
            usersData[i - 1][1] = rs2.getObject("login");
            usersData[i - 1][2] = rs2.getObject("name");
            usersData[i - 1][3] = rs2.getObject("surname");
            usersData[i - 1][4] = rs2.getObject("type");
            usersData[i - 1][5] = rs2.getObject("joined");
        }
        return usersData;
    }

    public int addNewUser(String userLogin, String userPass, String userName, String userSurname, String userPatronymic, String userType) throws SQLException {
        String sql = "INSERT INTO users (login,pass,name,surname,patronymic,type) VALUES (?,?,?,?,?,?)";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, userLogin);
        st.setString(2, userPass);
        st.setString(3, userName);
        st.setString(4, userSurname);
        st.setString(5, userPatronymic);
        st.setString(6, userType);
        st.executeUpdate();
        String sql2 = "SELECT MAX(id) FROM users";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int id = rs2.next() ? rs2.getInt(1) : -1;
        return id;
    }

    public void addUserToGroup(int userId, int groupId) throws SQLException {
        String sql1 = "INSERT INTO users_to_groups (id_users,id_groups) VALUES (?,?)";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, userId);
        st1.setInt(2, groupId);
        st1.executeUpdate();
    }

    public Object[] getOneUser(int id) throws SQLException {
        String sql1 = "SELECT * FROM users WHERE id=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        st2.setInt(1, id);
        ResultSet rs2 = st2.executeQuery();
        Object[] oneUserData = new Object[7];
        rs2.next();
        oneUserData[0] = rs2.getObject("id");
        oneUserData[1] = rs2.getObject("login");
        oneUserData[2] = rs2.getObject("pass");
        oneUserData[3] = rs2.getObject("name");
        oneUserData[4] = rs2.getObject("surname");
        oneUserData[5] = rs2.getObject("patronymic");
        oneUserData[6] = rs2.getObject("type");
        return oneUserData;
    }

    public void deleteUser(int id) throws SQLException {
        String sql1 = "DELETE FROM users WHERE id=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        st2.setInt(1, id);
        st2.executeUpdate();
    }

    public void updateUser(int id, String userLogin, String userPass, String userName, String userSurname, String userPatronymic, String userType) throws SQLException {
        String sql1 = "UPDATE users SET login=?, pass=?, name=?, surname=?, patronymic=?, type=? WHERE id=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        st2.setString(1, userLogin);
        st2.setString(2, userPass);
        st2.setString(3, userName);
        st2.setString(4, userSurname);
        st2.setString(5, userPatronymic);
        st2.setString(6, userType);
        st2.setInt(7, id);
        st2.executeUpdate();
    }

    public void deleteUserFromGroups(int userId) throws SQLException {
        String sql1 = "DELETE FROM users_to_groups WHERE id_users=" + userId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
    }

    public void deleteUserFromGroups(int userId, int[] groupsIds) throws SQLException {
        String sql1 = "DELETE FROM users_to_groups WHERE id_users=" + userId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
    }

    public Object[][] getAllSwfData() throws SQLException {
        String sql1 = "SELECT COUNT(*) FROM resources";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int rows = rs1.next() ? rs1.getInt(1) : 0;
        String sql2 = "SELECT * FROM resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        ResultSetMetaData metaData = rs2.getMetaData();
        int cols = metaData.getColumnCount();
        Object[][] filesData = new Object[rows][cols];
        for (int i = 1; i <= rows; ++i) {
            rs2.next();
            for (int j = 1; j <= cols; ++j) {
                filesData[i - 1][j - 1] = rs2.getObject(j);
            }
        }
        return filesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNewSwf(String filename) {
        FileInputStream fis = null;
        int id = -1;
        try {
            String sql = "INSERT INTO resources (data) values (?)";
            int s = 0;
            byte[] person_image = null;
            File image = new File(filename);
            fis = new FileInputStream(image);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try {
                int readNum;
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            person_image = bos.toByteArray();
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setBytes(1, person_image);
            s = st.executeUpdate();
            if (s > 0) {
                // empty if block
            }
            st.close();
            String sql2 = "SELECT MAX(id) FROM resources";
            PreparedStatement st2 = this.conn.prepareStatement(sql2);
            ResultSet rs2 = st2.executeQuery();
            id = rs2.next() ? rs2.getInt(1) : -1;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return id;
    }

    public void saveAsSwf(int id) throws SQLException, FileNotFoundException, IOException {
        String sql = "SELECT data FROM resources WHERE id=?";
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        stmt.setInt(1, id);
        ResultSet rs = stmt.executeQuery();
        File image = new File("prev.swf");
        while (rs.next()) {
            Object obj = rs.getObject(1);
            FileOutputStream fos = new FileOutputStream(image);
            fos.write((byte[])obj);
            fos.flush();
            fos.close();
            rs.next();
        }
        rs.close();
    }

    public int getResourceSizeById(int id) throws SQLException {
        String sql = "SELECT size FROM resources_info WHERE id_resources=" + id;
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        ResultSet rs = stmt.executeQuery();
        int size = rs.next() ? rs.getInt(1) : 0;
        return size;
    }

    public int getThumbSizeById(int id) throws SQLException {
        String sql = "SELECT thumb_size FROM resources_info WHERE id_resources=" + id;
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        ResultSet rs = stmt.executeQuery();
        int size = rs.next() ? rs.getInt(1) : 0;
        return size;
    }

    public Object[][] getAllResInfo() throws SQLException {
        String sql1 = "SELECT COUNT(*) FROM resources_info";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int rows = rs1.next() ? rs1.getInt(1) : 0;
        String sql2 = "SELECT * FROM resources_info ORDER BY grade";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        ResultSetMetaData metaData = rs2.getMetaData();
        int cols = metaData.getColumnCount();
        Object[][] usersData = new Object[rows][cols];
        for (int i = 1; i <= rows; ++i) {
            rs2.next();
            for (int j = 1; j <= cols; ++j) {
                usersData[i - 1][j - 1] = rs2.getObject(j);
            }
        }
        return usersData;
    }

    public ArrayList<LinkedHashMap<String, String>> getAllCustomResInfo(int userId) throws SQLException {
        String sql2 = "SELECT * FROM custom_resources WHERE id_users=" + userId + " ORDER BY id";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        ArrayList<LinkedHashMap<String, String>> data = new ArrayList<LinkedHashMap<String, String>>();
        while (rs2.next()) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            row.put("id", Integer.toString(rs2.getInt("id")));
            row.put("grade", rs2.getString("custom_resource_grade"));
            row.put("subject", rs2.getString("custom_resource_subject"));
            row.put("lesson", rs2.getString("custom_resource_lesson"));
            row.put("published", rs2.getString("published"));
            data.add(row);
        }
        return data;
    }

    public ArrayList<HashMap<String, Object>> getAllResourcesInfo() throws SQLException {
        String sql1 = "SELECT * FROM resources_info";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        while (rs1.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id_resources", rs1.getString("id_resources"));
            row.put("grade", rs1.getString("grade"));
            row.put("subject", rs1.getString("subject"));
            row.put("chapter", rs1.getString("chapter"));
            row.put("theme", rs1.getString("theme"));
            row.put("lesson", rs1.getString("lesson"));
            list.add(row);
        }
        return list;
    }

    public Vector<Vector<Object>> getUserAssignments(int userId) throws SQLException {
        String sql2 = "SELECT * FROM assignments WHERE id_users=" + userId + " ORDER BY assignments_arrange";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        Vector<Vector<Object>> assigns = new Vector<Vector<Object>>();
        while (rs2.next()) {
            Vector<String> row = new Vector<String>();
            row.add(rs2.getString("id"));
            row.add(rs2.getString("id_users"));
            row.add(rs2.getString("name"));
            row.add(rs2.getString("type"));
            row.add(rs2.getString("time"));
            row.add(rs2.getString("delay_time"));
            row.add(rs2.getString("comments"));
            row.add(rs2.getString("assignments_arrange"));
            assigns.add(row);
        }
        return assigns;
    }

    public Vector<Vector<Object>> getUserAssignmentsFromOneTeacher(int userId, int teacherId) throws SQLException {
        String sql2 = "SELECT assignments.id,assignments.name, assignments.type, assignments.time, assignments.delay_time, assignments.comments, assignments_to_users.assignments_arrange FROM assignments_to_users JOIN assignments ON assignments.id=assignments_to_users.id_assignments WHERE assignments_to_users.id_users=" + userId + " " + "AND assignments.id_users=" + teacherId + " " + "ORDER BY assignments_to_users.assignments_arrange";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        Vector<Vector<Object>> assigns = new Vector<Vector<Object>>();
        while (rs2.next()) {
            Vector<String> row = new Vector<String>();
            row.add(rs2.getString("id"));
            row.add(rs2.getString("name"));
            row.add(rs2.getString("type"));
            row.add(rs2.getString("time"));
            row.add(rs2.getString("delay_time"));
            row.add(rs2.getString("comments"));
            row.add(rs2.getString("assignments_arrange"));
            assigns.add(row);
        }
        return assigns;
    }

    public Vector getAssignmentResourcesIds(int assId) throws SQLException {
        String sql1 = "SELECT id_resources FROM resources_to_assignments WHERE id_assignments=? ORDER BY resources_arrange";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, assId);
        ResultSet rs1 = st1.executeQuery();
        Vector<Integer> data = new Vector<Integer>();
        while (rs1.next()) {
            data.add(rs1.getInt("id_resources"));
        }
        return data;
    }

    public int createAssignment(int userId, String name, String type, String time, String delay_time, String comments) throws SQLException {
        String sql1 = "INSERT INTO assignments (id_users,name,type,time,delay_time,comments) VALUES (?,?,?,?,?,?)";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, userId);
        st1.setString(2, name);
        st1.setString(3, type);
        st1.setString(4, time);
        st1.setString(5, delay_time);
        st1.setString(6, comments);
        st1.executeUpdate();
        st1.close();
        int newAssId = this.getMaxId("assignments");
        int maxArrange = this.getAssignmentMaxArrangeNum(userId);
        this.setAssignmentArrangeNum(userId, newAssId, maxArrange + 1);
        return newAssId;
    }

    public void deleteAssignment(int assId) throws SQLException {
        String sql1 = "DELETE FROM assignments WHERE id=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, assId);
        st1.executeUpdate();
        st1.close();
        String sql2 = "DELETE FROM resources_to_assignments WHERE id_assignments=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        st2.setInt(1, assId);
        st2.executeUpdate();
        st2.close();
    }

    public int duplicateAssignment(int assId, int userId) throws SQLException {
        String sql1 = "INSERT INTO assignments (id_users, name, type, time, delay_time, comments, assignments_arrange) SELECT id_users, name, type, time, delay_time, comments, assignments_arrange FROM assignments WHERE id=" + assId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
        int newId = this.getMaxId("assignments");
        int newArrangeNum = this.getAssignmentMaxArrangeNum(userId);
        this.setAssignmentArrangeNum(userId, newId, newArrangeNum + 1);
        Vector allSwfsIds = this.getAssignmentResourcesIds(assId);
        for (Object e : allSwfsIds) {
            String sql2 = "INSERT INTO resources_to_assignments (id_assignments,id_resources) VALUES (?,?)";
            PreparedStatement st2 = this.conn.prepareStatement(sql2);
            st2.setInt(1, newId);
            st2.setInt(2, Integer.valueOf(e.toString()));
            st2.executeUpdate();
            st2.close();
        }
        return newId;
    }

    public void deleteLessonFromAssignment(int assId, int resId) throws SQLException {
        String sql1 = "DELETE FROM resources_to_assignments WHERE id_assignments=? AND id_resources=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, assId);
        st1.setInt(2, resId);
        st1.executeUpdate();
    }

    public int getMaxId(String tableName) throws SQLException {
        String sql1 = "SELECT MAX(id) FROM " + tableName;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        return rs1.next() ? rs1.getInt(1) : -1;
    }

    public int getAssignmentMaxArrangeNum(int userId) throws SQLException {
        String sql1 = "SELECT MAX(assignments_arrange) FROM assignments WHERE id_users=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, userId);
        ResultSet rs1 = st1.executeQuery();
        int result = rs1.next() ? rs1.getInt(1) : 0;
        return result;
    }

    public void setAssignmentArrangeNum(int userId, int assId, int arrangeNum) throws SQLException {
        String sql1 = "UPDATE assignments SET assignments_arrange=? WHERE id=? AND id_users=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, arrangeNum);
        st1.setInt(2, assId);
        st1.setInt(3, userId);
        st1.executeUpdate();
    }

    void setArrangeForAssignments(int userId, String[] assignmentsIds) throws SQLException {
        for (int i = 0; i < assignmentsIds.length; ++i) {
            String sql1 = "UPDATE assignments SET assignments_arrange=? WHERE id=? AND id_users=?";
            PreparedStatement st1 = this.conn.prepareStatement(sql1);
            int assId = Integer.valueOf(assignmentsIds[i]);
            st1.setInt(1, i + 1);
            st1.setInt(2, assId);
            st1.setInt(3, userId);
            st1.executeUpdate();
            st1.close();
        }
    }

    public String[] getStudents() throws SQLException {
        String sql1 = "SELECT COUNT(*) FROM users WHERE user_type='student'";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int rows = rs1.next() ? rs1.getInt(1) : 0;
        String sql2 = "SELECT user_name FROM users WHERE user_type='student'";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        String[] students = new String[rows];
        for (int i = 1; i <= rows; ++i) {
            rs2.next();
            students[i - 1] = rs2.getString("user_name");
        }
        return students;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewJpg(String filename, int id) {
        FileInputStream fis = null;
        try {
            String sql = "INSERT INTO thumbs (thumb,id_resources) values (?,?)";
            int s = 0;
            byte[] person_image = null;
            File image = new File(filename);
            fis = new FileInputStream(image);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try {
                int readNum;
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            person_image = bos.toByteArray();
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setBytes(1, person_image);
            st.setInt(2, id);
            s = st.executeUpdate();
            if (s > 0) {
                // empty if block
            }
            st.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Object getOneCellValue(String col, String table, int id) throws SQLException {
        String sql1 = "SELECT " + col + " FROM " + table + " WHERE id=" + id;
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        ResultSet rs2 = st2.executeQuery();
        String data = rs2.next() ? rs2.getObject(col) : "";
        return data;
    }

    public Object getOneCellValue(String col, String table) throws SQLException {
        String sql1 = "SELECT " + col + " FROM " + table;
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        ResultSet rs2 = st2.executeQuery();
        String data = rs2.next() ? rs2.getObject(col) : "";
        st2.close();
        return data;
    }

    public void setNewSwfInfo(String grade, String subject, String chapter, String theme, String lesson, String filename, long swfSize, long jpgSize) throws SQLException {
        String sql2 = "SELECT MAX(id) FROM resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int id = rs2.next() ? rs2.getInt(1) : -1;
        String sql = "INSERT INTO resources_info (grade,subject,chapter,theme,lesson,filename,size,thumb_size,id_resources) VALUES (?,?,?,?,?,?,?,?,?)";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, grade);
        st.setString(2, subject);
        st.setString(3, chapter);
        st.setString(4, theme);
        st.setString(5, lesson);
        st.setString(6, filename);
        st.setLong(7, swfSize);
        st.setLong(8, jpgSize);
        st.setInt(9, id);
        st.executeUpdate();
    }

    public void deleteResource(int id) throws SQLException {
        String sql2 = "DELETE FROM resources WHERE id=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        st2.setInt(1, id);
        st2.executeUpdate();
        String sql1 = "DELETE FROM resources_info WHERE id_resources=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, id);
        st1.executeUpdate();
        String sql3 = "DELETE FROM thumbs WHERE id_resources=?";
        PreparedStatement st3 = this.conn.prepareStatement(sql3);
        st3.setInt(1, id);
        st3.executeUpdate();
        st1.close();
        st2.close();
        st3.close();
    }

    public Object[] getOneResource(int id) throws SQLException {
        String sql2 = "SELECT MAX(id) FROM resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int maxId = rs2.next() ? rs2.getInt(1) : -1;
        Object[] obj = new Object[2];
        String sql3 = "SELECT data FROM resources";
        PreparedStatement st3 = this.conn.prepareStatement(sql3);
        ResultSet rs3 = st3.executeQuery();
        obj[0] = maxId;
        obj[1] = rs3.getObject("data");
        return obj;
    }

    public void editResourceById(int resId, int infId, String grade, String subject, String chapter, String theme, String lesson, String filename, String size, String thumbsize, String swfPath, String jpgPath) throws SQLException {
        File swfFile = new File(swfPath);
        File jpgFile = new File(jpgPath);
        if (swfFile.exists()) {
            try {
                size = Long.toString(swfFile.length());
                filename = swfFile.getName();
                this.updateSwfById(resId, swfPath);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (jpgFile.exists()) {
            try {
                thumbsize = Long.toString(jpgFile.length());
                this.updateThumbById(resId, jpgPath);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String sql1 = "UPDATE resources_info SET grade=?, subject=?, chapter=?, theme=?, lesson=?,filename=?, size=?, thumb_size=? WHERE id=?";
        PreparedStatement st2 = this.conn.prepareStatement(sql1);
        st2.setString(1, grade);
        st2.setString(2, subject);
        st2.setString(3, chapter);
        st2.setString(4, theme);
        st2.setString(5, lesson);
        st2.setString(6, filename);
        st2.setString(7, size);
        st2.setString(8, thumbsize);
        st2.setInt(9, infId);
        st2.executeUpdate();
    }

    public void updateSwfById(int id, String pathToSwf) throws SQLException, FileNotFoundException {
        String sql = "UPDATE resources SET data=? WHERE id=?";
        int s = 0;
        byte[] person_image = null;
        File image = new File(pathToSwf);
        FileInputStream fis = new FileInputStream(image);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        person_image = bos.toByteArray();
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setBytes(1, person_image);
        st.setInt(2, id);
        s = st.executeUpdate();
        if (s > 0) {
            // empty if block
        }
        st.close();
    }

    public void updateSwfInfoById(int resId, String grade, String subject, String chapter, String theme, String lesson, String filename, long swfSize, long jpgSize) throws SQLException {
        String sql1 = "UPDATE resources_info SET grade=?, subject=?, chapter=?, theme=?, lesson=?, filename=?, size=?, thumb_size=? WHERE id=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, grade);
        st1.setString(2, subject);
        st1.setString(3, chapter);
        st1.setString(4, theme);
        st1.setString(5, lesson);
        st1.setString(6, filename);
        st1.setLong(7, swfSize);
        st1.setLong(8, jpgSize);
        st1.setInt(9, resId);
        st1.executeUpdate();
    }

    public void updateThumbById(int id, String pathToThumb) throws SQLException, FileNotFoundException {
        String sql = "UPDATE thumbs SET thumb=? WHERE id=?";
        int s = 0;
        byte[] person_image = null;
        File image = new File(pathToThumb);
        FileInputStream fis = new FileInputStream(image);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
            person_image = bos.toByteArray();
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setBytes(1, person_image);
            st.setInt(2, id);
            s = st.executeUpdate();
            if (s > 0) {
                // empty if block
            }
            st.close();
            bos.close();
            fis.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void addIcon(String filename, String iconPathId) throws FileNotFoundException, SQLException {
        String sql = "INSERT INTO icons (icon_path,icon_data,icon_size) values (?,?,?)";
        int s = 0;
        byte[] person_image = null;
        File image = new File(filename);
        FileInputStream fis = new FileInputStream(image);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        person_image = bos.toByteArray();
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, iconPathId);
        st.setBytes(2, person_image);
        st.setLong(3, image.length());
        s = st.executeUpdate();
        if (s > 0) {
            // empty if block
        }
        st.close();
    }

    public void updateIcon(String filename, String iconPathId) throws FileNotFoundException, SQLException {
        String sql = "UPDATE icons SET icon_path=?,icon_data=?,icon_size=? WHERE icon_path=?";
        int s = 0;
        byte[] person_image = null;
        File image = new File(filename);
        FileInputStream fis = new FileInputStream(image);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        person_image = bos.toByteArray();
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, iconPathId);
        st.setBytes(2, person_image);
        st.setLong(3, image.length());
        st.setString(4, iconPathId);
        s = st.executeUpdate();
        if (s > 0) {
            // empty if block
        }
        st.close();
    }

    public int getIconSize(String icon_path) throws SQLException {
        String sql2 = "SELECT icon_size FROM icons WHERE icon_path='" + icon_path + "'";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int size = rs2.next() ? rs2.getInt(1) : -1;
        st2.close();
        rs2.close();
        return size;
    }

    public Object getIcon(String icon_path) throws SQLException {
        String sql = "SELECT icon_data FROM icons WHERE icon_path=?";
        PreparedStatement stmt = this.conn.prepareStatement(sql);
        stmt.setString(1, icon_path);
        ResultSet rs = stmt.executeQuery();
        rs.next();
        Object obj = rs.getObject(1);
        stmt.close();
        rs.close();
        return obj;
    }

    public Object[][] getAllIconsInfo() throws SQLException {
        String sql1 = "SELECT COUNT(*) FROM icons";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int rows = rs1.next() ? rs1.getInt(1) : 0;
        String sql2 = "SELECT icon_path,icon_size FROM icons";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        ResultSetMetaData metaData = rs2.getMetaData();
        int cols = metaData.getColumnCount();
        Object[][] usersData = new Object[rows][cols];
        for (int i = 1; i <= rows; ++i) {
            rs2.next();
            for (int j = 1; j <= cols; ++j) {
                usersData[i - 1][j - 1] = rs2.getObject(j);
            }
        }
        return usersData;
    }

    public Vector getAllGroups(int id) throws SQLException {
        String sql2 = "SELECT id FROM users WHERE type='admin'";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int adminId = rs2.next() ? rs2.getInt("id") : -1;
        String sql1 = "SELECT * FROM groups WHERE group_type=" + id + " OR group_type=0 OR group_type=" + adminId + " ORDER BY group_type";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        Vector groupsData = new Vector();
        while (rs1.next()) {
            Vector<Object> groupData = new Vector<Object>();
            groupData.add(rs1.getInt("id"));
            groupData.add(rs1.getString("group_name"));
            groupData.add(rs1.getInt("group_type"));
            groupsData.add(groupData);
        }
        return groupsData;
    }

    public void changeGroupName(String newName, int id) throws SQLException {
        String sql1 = "UPDATE groups SET group_name=? WHERE id=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, newName);
        st1.setInt(2, id);
        st1.executeUpdate();
    }

    public Vector getAllGroupsIds() throws SQLException {
        String sql1 = "SELECT id FROM groups";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        Vector<String> groupNames = new Vector<String>();
        while (rs1.next()) {
            groupNames.add(rs1.getString("id"));
        }
        return groupNames;
    }

    public Vector getGroupUsers(int id) throws SQLException {
        String sql1 = "SELECT users.name, users.surname, users.patronymic, users.id FROM users_to_groups JOIN users ON users.id=users_to_groups.id_users JOIN groups ON groups.id=users_to_groups.id_groups WHERE users_to_groups.id_groups=" + id;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ResultSetMetaData metaData = rs1.getMetaData();
        int cols = metaData.getColumnCount();
        Vector data = new Vector();
        while (rs1.next()) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
                vector.add(rs1.getObject(columnIndex));
            }
            data.add(vector);
        }
        return data;
    }

    public Vector getOneUserGroups(int userId) throws SQLException {
        String sql1 = "SELECT * FROM groups WHERE group_type=" + userId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        Vector groupsData = new Vector();
        while (rs1.next()) {
            Vector<Object> groupData = new Vector<Object>();
            groupData.add(rs1.getInt("id"));
            groupData.add(rs1.getString("group_name"));
            groupData.add(rs1.getInt("group_type"));
            groupsData.add(groupData);
        }
        return groupsData;
    }

    public Vector getGroupUsersFullInfo(int id) throws SQLException {
        String sql1 = "SELECT users.name, users.surname, users.patronymic, users.id, users.login, users.pass, users.type  FROM users_to_groups JOIN users ON users.id=users_to_groups.id_users JOIN groups ON groups.id=users_to_groups.id_groups WHERE users_to_groups.id_groups=" + id;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ResultSetMetaData metaData = rs1.getMetaData();
        int cols = metaData.getColumnCount();
        Vector data = new Vector();
        while (rs1.next()) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
                vector.add(rs1.getObject(columnIndex));
            }
            data.add(vector);
        }
        return data;
    }

    public void changeUserGroup(int userId, int newGroupId, int oldGroupId) throws SQLException {
        String sql1 = "UPDATE users_to_groups SET id_groups=? WHERE id_users=? AND id_groups=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, newGroupId);
        st1.setInt(2, userId);
        st1.setInt(3, oldGroupId);
        st1.executeUpdate();
    }

    public int checkUserInGroup(int userId, int groupId) throws SQLException {
        String sql1 = "SELECT id FROM users_to_groups WHERE id_users=? AND id_groups=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, userId);
        st1.setInt(2, groupId);
        ResultSet rs1 = st1.executeQuery();
        int result = rs1.next() ? rs1.getInt(1) : -1;
        return result;
    }

    public int createNewGroup(String group_name, int group_type) throws SQLException {
        String sql1 = "INSERT INTO groups (group_name,group_type) values (?,?)";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, group_name);
        st1.setInt(2, group_type);
        st1.executeUpdate();
        String sql2 = "SELECT MAX(id) FROM groups";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int newId = rs2.next() ? rs2.getInt(1) : -1;
        return newId;
    }

    public Vector getAllSubjects() throws SQLException {
        String sql1 = "SELECT DISTINCT subject FROM resources_info";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ResultSetMetaData metaData = rs1.getMetaData();
        Vector<Object> data = new Vector<Object>();
        while (rs1.next()) {
            data.add(rs1.getObject("subject"));
        }
        return data;
    }

    public boolean checkUserInAdminGroups(int userId, int adminId) throws SQLException {
        String sql1 = "SELECT id FROM groups WHERE group_type=? OR group_type=0";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, adminId);
        ResultSet rs1 = st1.executeQuery();
        ArrayList<Object> groupsResult = new ArrayList<Object>();
        while (rs1.next()) {
            groupsResult.add(rs1.getObject("id"));
        }
        for (Object e : groupsResult) {
            if (this.checkUserInGroup(userId, (Integer)e) == -1) continue;
            return true;
        }
        return false;
    }

    public void removeUserFromGroup(int userId, int groupId) throws SQLException {
        String sql1 = "DELETE FROM users_to_groups WHERE id_users=? AND id_groups=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, userId);
        st1.setInt(2, groupId);
        st1.executeUpdate();
    }

    public Vector getSearchResInfo(String gradeF, String subjF, String searchF) throws SQLException {
        String WHERE = "";
        String grade = "";
        String AND = "";
        String S_AND = "";
        String subject = "";
        String search = "";
        String sql1 = "SELECT id_resources, grade, subject, lesson, size, thumb_size FROM resources_info ";
        if (!(gradeF.isEmpty() && subjF.isEmpty() && searchF.isEmpty())) {
            WHERE = " WHERE ";
        }
        if (!gradeF.isEmpty() && !subjF.isEmpty()) {
            AND = " AND ";
        }
        if (!gradeF.isEmpty()) {
            grade = " grade='" + gradeF + "' ";
        }
        if (!subjF.isEmpty()) {
            subject = " subject='" + subjF + "' ";
        }
        if (!searchF.isEmpty()) {
            search = " lesson LIKE '%" + searchF + "%' ";
        }
        if (!(searchF.isEmpty() || gradeF.isEmpty() && subjF.isEmpty())) {
            S_AND = " AND ";
        }
        if (!searchF.isEmpty() && gradeF.isEmpty() && subjF.isEmpty()) {
            S_AND = "";
        }
        sql1 = sql1 + WHERE + grade + AND + subject + S_AND + search;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ResultSetMetaData metaData = rs1.getMetaData();
        int cols = metaData.getColumnCount();
        Vector data = new Vector();
        while (rs1.next()) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
                vector.add(rs1.getObject(columnIndex));
            }
            data.add(vector);
        }
        return data;
    }

    public Vector<Vector<Object>> getDefaultSubjects() throws SQLException {
        String sql1 = "SELECT * FROM subjects";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        ResultSetMetaData metaData = rs1.getMetaData();
        int cols = metaData.getColumnCount();
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        while (rs1.next()) {
            Vector<Object> vector = new Vector<Object>();
            for (int columnIndex = 1; columnIndex <= cols; ++columnIndex) {
                vector.add(rs1.getObject(columnIndex));
            }
            data.add(vector);
        }
        return data;
    }

    public int addDefaultSubject(String newSubj) throws SQLException {
        String sql1 = "INSERT INTO subjects (subject_name) VALUES (?)";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, newSubj);
        st1.executeUpdate();
        String sql2 = "SELECT MAX(id) FROM subjects";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int id = rs2.next() ? rs2.getInt(1) : -1;
        return id;
    }

    public void deleteDefaultSubject(int subjId) throws SQLException {
        String sql1 = "DELETE FROM subjects WHERE id=" + subjId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
    }

    public void renameDefaultSubject(int subjId, String newName) throws SQLException {
        String sql1 = "UPDATE subjects SET subject_name='" + newName + "' WHERE id=" + subjId;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
    }

    public int checkGroupExistanceByName(String groupName) throws SQLException {
        String sql1 = "SELECT id FROM groups WHERE group_name='" + groupName + "'";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        int checkId = rs1.next() ? rs1.getInt("id") : -1;
        return checkId;
    }

    public int getTeachersGroupId() throws SQLException {
        String sql1 = "SELECT id FROM groups WHERE group_type=0 AND group_name='\u0423\u0447\u0438\u0442\u0435\u043b\u044f'";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        rs1.next();
        return rs1.getInt("id");
    }

    public static void main(String[] args) throws SQLException {
    }

    public int getThumbIdByResId(int resId) throws SQLException {
        String sql1 = "SELECT id FROM thumbs WHERE id_resources=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, resId);
        ResultSet rs1 = st1.executeQuery();
        int thumbId = rs1.next() ? rs1.getInt("id") : -1;
        return thumbId;
    }

    public void updateOneCell(int id, String table, String cell, String value) throws SQLException {
        String sql1 = "UPDATE " + table + " SET " + cell + "='" + value + "' WHERE id=" + id;
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.executeUpdate();
    }

    public void addLessonsToAssignment(int assId, String[] lessonsIds) throws SQLException {
        String sql1 = "INSERT INTO resources_to_assignments (id_assignments,id_resources) VALUES (?,?)";
        for (int i = 0; i < lessonsIds.length; ++i) {
            int lessonId = Integer.valueOf(lessonsIds[i]);
            PreparedStatement st1 = this.conn.prepareStatement(sql1);
            st1.setInt(1, assId);
            st1.setInt(2, Integer.valueOf(lessonsIds[i]));
            st1.executeUpdate();
            st1.close();
            int maxArrange = this.getLessonsMaxArrangeNum(assId);
            this.setLessonArrangeNum(assId, lessonId, maxArrange + 1);
        }
    }

    public int getLessonsMaxArrangeNum(int assId) throws SQLException {
        String sql1 = "SELECT MAX(resources_arrange) FROM resources_to_assignments WHERE id_assignments=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, assId);
        ResultSet rs1 = st1.executeQuery();
        int result = rs1.next() ? rs1.getInt(1) : 0;
        return result;
    }

    public void setLessonArrangeNum(int assId, int lessonId, int arrangeNum) throws SQLException {
        String sql1 = "UPDATE resources_to_assignments SET resources_arrange=? WHERE id_assignments=? AND id_resources=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setInt(1, arrangeNum);
        st1.setInt(2, assId);
        st1.setInt(3, lessonId);
        st1.executeUpdate();
    }

    void setArrangeForLessons(int assId, String[] lessonsIds) throws SQLException {
        for (int i = 0; i < lessonsIds.length; ++i) {
            String sql1 = "UPDATE resources_to_assignments SET resources_arrange=? WHERE id_assignments=? AND id_resources=?";
            PreparedStatement st1 = this.conn.prepareStatement(sql1);
            int lessonId = Integer.valueOf(lessonsIds[i]);
            st1.setInt(1, i + 1);
            st1.setInt(2, assId);
            st1.setInt(3, lessonId);
            st1.executeUpdate();
            st1.close();
        }
    }

    void changeAssignmentSettings(int assId, String type, String time, String delay_time, String comments) throws SQLException {
        String sql1 = "UPDATE assignments SET type=?, time=?, delay_time=?, comments=? WHERE id=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, type);
        st1.setString(2, time);
        st1.setString(3, delay_time);
        st1.setString(4, comments);
        st1.setInt(5, assId);
        st1.executeUpdate();
        st1.close();
    }

    public Vector getDefaultSubjectsList() throws SQLException {
        String sql1 = "SELECT subject_name FROM subjects ORDER BY subject_name";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        ResultSet rs1 = st1.executeQuery();
        Vector<String> data = new Vector<String>();
        while (rs1.next()) {
            data.add(rs1.getString("subject_name"));
        }
        return data;
    }

    public int createNewCustomLesson(int userId, String grade, String subject, String lesson) throws SQLException {
        String sql = "INSERT INTO custom_resources (id_users,custom_resource_grade,custom_resource_subject,custom_resource_lesson,published) VALUES (?,?,?,?,?)";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setInt(1, userId);
        st.setString(2, grade);
        st.setString(3, subject);
        st.setString(4, lesson);
        st.setString(5, "false");
        st.executeUpdate();
        String sql2 = "SELECT MAX(id) FROM custom_resources";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs2 = st2.executeQuery();
        int id = rs2.next() ? rs2.getInt(1) : -1;
        return id;
    }

    void deleteResourceByDiscName(String grade, String subject, String chapter) throws SQLException {
        String sql = "SELECT id_resources FROM resources_info WHERE grade=? AND subject=? AND chapter=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, grade);
        st.setString(2, subject);
        st.setString(3, chapter);
        ResultSet rs = st.executeQuery();
        int id = -1;
        while (rs.next()) {
            id = rs.getInt("id_resources");
            this.deleteResource(id);
        }
        st.close();
    }

    void setResourcesDeleted(String grade, String subject, String chapter) throws SQLException {
        String sql = "UPDATE resources_info SET active='deleted' WHERE grade='" + grade + "' AND subject='" + subject + "' AND chapter='" + chapter + "'";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.close();
    }

    int containsThisResource(String branch) throws SQLException {
        String sql = "SELECT id_resources FROM resources_info WHERE branch=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, branch);
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt("id_resources") : -1;
        return id;
    }

    int containsThisResource(String grade, String subject, String filename) throws SQLException {
        String sql = "SELECT id_resources FROM resources_info WHERE grade=? AND subject=? AND filename=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, grade);
        st.setString(2, subject);
        st.setString(3, filename);
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt("id_resources") : -1;
        return id;
    }

    void updateResource(Object res, String path, String filename, String hash, int id) throws SQLException {
        String sql = "UPDATE resources SET hash=? WHERE id=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        byte[] bytes = (byte[])res;
        st.setString(1, hash);
        st.setInt(2, id);
        st.executeUpdate();
        st.close();
        File dirFile = new File(path + File.separator + "bin" + File.separator + hash + File.separator + id + File.separator);
        File file = new File(path + File.separator + "bin" + File.separator + hash + File.separator + id + File.separator + filename);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        try {
            FileOutputStream fout = new FileOutputStream(file);
            fout.write(bytes);
            fout.close();
            bytes = null;
        }
        catch (IOException ex) {
            bytes = null;
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void updateThumb(int id, Object thumb) throws SQLException {
        String sql = "UPDATE thumbs SET thumb=? WHERE id_resources=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        byte[] bytes = (byte[])thumb;
        st.setBytes(1, bytes);
        st.setInt(2, id);
        st.executeUpdate();
        st.close();
    }

    void updateResourceInfo(int id, String theme, String grade, String subject, String lesson, String chapter, int answers, String filename, String themeArr, String lessonArr) throws SQLException {
        String sql = "UPDATE resources_info SET theme=?,grade=?,subject=?,lesson=?,chapter=?,answers_count=?,filename=?,active=?,theme_arrange=?,lesson_arrange=? WHERE id_resources=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, theme);
        st.setString(2, grade);
        st.setString(3, subject);
        st.setString(4, lesson);
        st.setString(5, chapter);
        st.setInt(6, answers);
        st.setString(7, filename);
        st.setString(8, "installing");
        st.setString(9, themeArr);
        st.setString(10, lessonArr);
        st.setInt(11, id);
        st.executeUpdate();
        st.close();
    }

    public void changeDiscStatus(String grade, String chapter, String oldStatus, String newStatus) throws SQLException {
        String sql = "UPDATE resources_info SET active=? WHERE grade=? AND chapter=? AND active=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, newStatus);
        st.setString(2, grade);
        st.setString(3, chapter);
        st.setString(4, oldStatus);
        int updated = st.executeUpdate();
        st.close();
    }

    public void setProductStatus(String productName, byte[] encodedString) throws SQLException {
        String sql1 = "SELECT product,id FROM products WHERE product=?";
        PreparedStatement st1 = this.conn.prepareStatement(sql1);
        st1.setString(1, productName);
        ResultSet rs1 = st1.executeQuery();
        int foundId = rs1.next() ? rs1.getInt("id") : -1;
        st1.close();
        if (foundId != -1) {
            String sql3 = "UPDATE products SET status=? WHERE id=?";
            PreparedStatement st3 = this.conn.prepareStatement(sql3);
            st3.setBytes(1, encodedString);
            st3.setInt(2, foundId);
            st3.executeUpdate();
            st3.close();
            return;
        }
        String sql2 = "INSERT INTO products (product,status) VALUES (?,?)";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        st2.setString(1, productName);
        st2.setBytes(2, encodedString);
        st2.executeUpdate();
        st2.close();
    }

    public HashMap<String, Integer> getSwfsIds() throws SQLException {
        String sql = "SELECT filename,id FROM resources";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        while (rs.next()) {
            map.put(rs.getString("filename"), rs.getInt("id"));
        }
        st.close();
        return map;
    }

    public HashMap<String, Integer> getSwfsIds(String chapter) throws SQLException {
        String sql = "SELECT id_resources,filename FROM resources_info WHERE chapter=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, chapter);
        ResultSet rs = st.executeQuery();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        while (rs.next()) {
            map.put(rs.getString("filename"), rs.getInt("id_resources"));
        }
        st.close();
        return map;
    }

    void deleteDiscInfo(String chapter) throws SQLException {
        String sql = "DELETE FROM resources_info WHERE chapter=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, chapter);
        st.executeUpdate();
        st.close();
    }

    public int checkContainsSwf(String filename) throws SQLException {
        String sql = "SELECT id FROM resources WHERE filename=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt("id") : -1;
        return id;
    }

    public byte[] getSwf(int resId) throws SQLException {
        String sql = "SELECT data FROM resources WHERE id=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setInt(1, resId);
        ResultSet rs = st.executeQuery();
        byte[] swf = rs.next() ? rs.getBytes("data") : null;
        return swf;
    }

    public byte[] getThumb(int resId) throws SQLException {
        String sql = "SELECT thumb FROM thumbs WHERE id_resources=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setInt(1, resId);
        ResultSet rs = st.executeQuery();
        byte[] thumb = rs.next() ? rs.getBytes("thumb") : null;
        return thumb;
    }

    public Connection getConn() {
        return this.conn;
    }

    public int getKeywordId(String keyword) throws SQLException {
        String sql = "SELECT id FROM keywords WHERE keyword=?";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, keyword);
        ResultSet rs = st.executeQuery();
        int id = rs.next() ? rs.getInt("id") : -1;
        st.close();
        return id;
    }

    public void setKeywordsToResource(ArrayList<Integer> keywordsIds, int resId) throws SQLException {
        String sql = "INSERT INTO keywords_to_resources (id_resources,id_keywords) VALUES (?,?)";
        PreparedStatement st = this.conn.prepareStatement(sql);
        for (int i = 0; i < keywordsIds.size(); ++i) {
            if (this.isKeywordAlreadySetToResource(keywordsIds.get(i), resId)) continue;
            st.setInt(1, resId);
            st.setInt(2, keywordsIds.get(i));
            st.addBatch();
        }
        st.executeBatch();
        st.clearBatch();
        st.close();
    }

    public boolean isKeywordAlreadySetToResource(int keywordId, int resId) {
        String sql = "SELECT id FROM keywords_to_resources WHERE id_keywords=? AND id_resources=?";
        boolean chk = false;
        try {
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setInt(1, keywordId);
            st.setInt(2, resId);
            ResultSet rs = st.executeQuery();
            chk = rs.next();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
        return chk;
    }

    public int setKeyword(String keyword) throws SQLException {
        String sql = "INSERT INTO keywords (keyword) VALUES (?)";
        PreparedStatement st = this.conn.prepareStatement(sql);
        st.setString(1, keyword);
        st.executeUpdate();
        String sql2 = "SELECT MAX(id) FROM keywords";
        PreparedStatement st2 = this.conn.prepareStatement(sql2);
        ResultSet rs = st2.executeQuery();
        int newId = rs.next() ? rs.getInt(1) : -1;
        st.close();
        return newId;
    }

    public int countResources() throws SQLException {
        String sql = "SELECT COUNT(id) FROM resources";
        PreparedStatement st = this.conn.prepareStatement(sql);
        ResultSet rs = st.executeQuery();
        int count = rs.next() ? rs.getInt(1) : 0;
        st.close();
        return count;
    }

    public HashMap<String, Integer> getIdsAndFilenames() throws SQLException {
        String sql = "SELECT id, filename FROM resources";
        Statement st = this.conn.createStatement();
        long d1 = new Date().getTime();
        ResultSet rs = st.executeQuery(sql);
        long d2 = new Date().getTime();
        d1 = new Date().getTime();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        while (rs.next()) {
            data.put(rs.getString("filename"), rs.getInt("id"));
        }
        d2 = new Date().getTime();
        st.close();
        return new HashMap<String, Integer>();
    }

    public void setTreeLastModifiedDate(long updateDate) {
        String sql = "UPDATE system SET tree_update_date=?";
        try {
            PreparedStatement st = this.conn.prepareStatement(sql);
            st.setLong(1, updateDate);
            st.executeUpdate();
            st.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DbManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

