/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.beans.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class XMLDecoder {
    private final AccessControlContext acc = AccessController.getContext();
    private InputStream in;
    private Object owner;
    private ExceptionListener exceptionListener;
    private ObjectHandler handler;
    private Reference clref;

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null);
    }

    public XMLDecoder(InputStream inputStream, Object object) {
        this(inputStream, object, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener) {
        this(inputStream, object, exceptionListener, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        this.in = inputStream;
        this.setOwner(object);
        this.setExceptionListener(exceptionListener);
        this.setClassLoader(classLoader);
    }

    private void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.clref = new WeakReference<ClassLoader>(classLoader);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.clref != null) {
            return (ClassLoader)this.clref.get();
        }
        return null;
    }

    public void close() {
        if (this.in != null) {
            this.getHandler();
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                this.getExceptionListener().exceptionThrown(iOException);
            }
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener != null ? this.exceptionListener : Statement.defaultExceptionListener;
    }

    public Object readObject() {
        if (this.in == null) {
            return null;
        }
        return this.getHandler().dequeueResult();
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    public Object getOwner() {
        return this.owner;
    }

    private ObjectHandler getHandler() {
        if (this.handler == null) {
            if (this.acc == null && null != System.getSecurityManager()) {
                throw new SecurityException("AccessControlContext is not set");
            }
            this.handler = AccessController.doPrivileged(new PrivilegedAction<ObjectHandler>(){

                @Override
                public ObjectHandler run() {
                    ObjectHandler objectHandler = new ObjectHandler(XMLDecoder.this, XMLDecoder.this.getClassLoader());
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    try {
                        SAXParser sAXParser = sAXParserFactory.newSAXParser();
                        sAXParser.parse(XMLDecoder.this.in, (HandlerBase)objectHandler);
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        XMLDecoder.this.getExceptionListener().exceptionThrown(parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        Exception exception = sAXException.getException();
                        if (exception == null) {
                            exception = sAXException;
                        }
                        XMLDecoder.this.getExceptionListener().exceptionThrown(exception);
                    }
                    catch (IOException iOException) {
                        XMLDecoder.this.getExceptionListener().exceptionThrown(iOException);
                    }
                    return objectHandler;
                }
            }, this.acc);
        }
        return this.handler;
    }
}

