/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import productinstaller.ListObject;
import productinstaller.ProductInstaller;

class XmlPrefs {
    ProductInstaller productInstaller;
    Document doc;

    public XmlPrefs(Document doc, ProductInstaller productInstaller) {
        this.doc = doc;
        this.productInstaller = productInstaller;
        InputStream is = this.getClass().getResourceAsStream("gui.xml");
        if (doc == null) {
            try {
                this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(XmlPrefs.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(XmlPrefs.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(XmlPrefs.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getStr(String value) {
        Node e = this.doc.getElementsByTagName("main").item(0);
        String s = e.getAttributes().getNamedItem(value).getTextContent();
        return s;
    }

    public String getString(String key) {
        NodeList stringNodes = this.doc.getElementsByTagName("string");
        for (int i = 0; i < stringNodes.getLength(); ++i) {
            NamedNodeMap attributes = stringNodes.item(i).getAttributes();
            Node value = attributes.getNamedItem(key);
            if (value == null) continue;
            return value.getTextContent();
        }
        return "";
    }

    public boolean getInstallPrefAsBoolean(String value) {
        Node node = this.doc.getElementsByTagName("install").item(0);
        String string = node.getAttributes().getNamedItem(value).getTextContent();
        boolean boolValue = false;
        try {
            boolValue = Boolean.valueOf(string);
        }
        catch (Exception ex) {
            return boolValue;
        }
        return boolValue;
    }

    public String getInstallPrefAsString(String value) {
        Node node = this.doc.getElementsByTagName("install").item(0);
        String string = node.getAttributes().getNamedItem(value).getTextContent();
        return string;
    }

    public int getInt(String value) {
        return Integer.valueOf(this.getStr(value));
    }

    public Vector<ListObject> getModulesList() {
        NodeList objNodes = this.doc.getElementsByTagName("object");
        Vector<ListObject> objectsToInstall = new Vector<ListObject>();
        for (int i = 0; i < objNodes.getLength(); ++i) {
            Node node = objNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String discName = node.getAttributes().getNamedItem("name").getTextContent();
            String iconPath = node.getAttributes().getNamedItem("icon").getTextContent();
            String sourceDir = node.getAttributes().getNamedItem("data").getTextContent();
            boolean boxChecked = Boolean.valueOf(node.getAttributes().getNamedItem("boxChecked").getTextContent());
            boolean boxEnabled = Boolean.valueOf(node.getAttributes().getNamedItem("boxEnabled").getTextContent());
            boolean boxVisible = Boolean.valueOf(node.getAttributes().getNamedItem("boxVisible").getTextContent());
            String type = node.getAttributes().getNamedItem("type").getTextContent();
            String description = this.getDescription(node);
            ListObject listObject = new ListObject(iconPath, discName, type, description, boxEnabled, boxChecked, boxVisible);
            listObject.setSourceDir(sourceDir);
            objectsToInstall.add(listObject);
        }
        return objectsToInstall;
    }

    private String getDescription(Node node) {
        NodeList children = node.getChildNodes();
        String description = "";
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            description = children.item(i).getTextContent();
        }
        return description;
    }
}

