/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.MouseEvent;
import java.awt.peer.ScrollPanePeer;
import sun.awt.AWTAccessor;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;

class XScrollPanePeer
extends XComponentPeer
implements ScrollPanePeer,
XScrollbarClient {
    public static final int MARGIN = 1;
    public static final int SCROLLBAR = 17;
    public static final int SPACE = 2;
    public static final int SCROLLBAR_INSET = 2;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    XWindow clip = null;
    int active = 1;
    int hsbSpace;
    int vsbSpace;
    int vval;
    int hval;
    int vmax;
    int hmax;

    XScrollPanePeer(ScrollPane scrollPane) {
        super(scrollPane);
        XScrollPaneContentWindow xScrollPaneContentWindow = new XScrollPaneContentWindow(scrollPane, this.window);
        this.clip = xScrollPaneContentWindow;
        this.vsb = new XVerticalScrollbar(this);
        this.hsb = new XHorizontalScrollbar(this);
        if (scrollPane.getScrollbarDisplayPolicy() == 1) {
            this.hsbSpace = 17;
            this.vsbSpace = 17;
        } else {
            this.hsbSpace = 0;
            this.vsbSpace = 0;
        }
        int n = 1;
        Adjustable adjustable = scrollPane.getVAdjustable();
        if (adjustable != null) {
            n = adjustable.getUnitIncrement();
        }
        int n2 = this.height - this.hsbSpace;
        this.vsb.setValues(0, n2, 0, n2, n, Math.max(1, (int)((double)n2 * 0.9)));
        this.vsb.setSize(this.vsbSpace - 2, n2);
        n = 1;
        Adjustable adjustable2 = scrollPane.getHAdjustable();
        if (adjustable2 != null) {
            n = adjustable2.getUnitIncrement();
        }
        int n3 = this.width - this.vsbSpace;
        this.hsb.setValues(0, n3, 0, n3, n, Math.max(1, (int)((double)n3 * 0.9)));
        this.hsb.setSize(n3, this.hsbSpace - 2);
        this.setViewportSize();
        this.clip.xSetVisible(true);
    }

    public long getContentWindow() {
        return this.clip == null ? this.window : this.clip.getWindow();
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        super.setBounds(n, n2, n3, n4, n5);
        if (this.clip == null) {
            return;
        }
        this.setScrollbarSpace();
        this.setViewportSize();
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1 + this.hsbSpace, 1 + this.vsbSpace);
    }

    public int getHScrollbarHeight() {
        return 17;
    }

    public int getVScrollbarWidth() {
        return 17;
    }

    public void childResized(int n, int n2) {
        if (this.setScrollbarSpace()) {
            this.setViewportSize();
        }
        this.repaint();
    }

    Dimension getChildSize() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.countComponents() > 0) {
            Component component = scrollPane.getComponent(0);
            return component.size();
        }
        return new Dimension(0, 0);
    }

    boolean setScrollbarSpace() {
        int n;
        int n2;
        ScrollPane scrollPane = (ScrollPane)this.target;
        boolean bl = false;
        int n3 = scrollPane.getScrollbarDisplayPolicy();
        if (n3 == 2) {
            return bl;
        }
        Dimension dimension = this.getChildSize();
        if (n3 == 0) {
            n2 = this.hsbSpace;
            n = this.vsbSpace;
            this.hsbSpace = dimension.width <= this.width - 2 ? 0 : 17;
            int n4 = this.vsbSpace = dimension.height <= this.height - 2 ? 0 : 17;
            if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                int n5 = this.hsbSpace = dimension.width <= this.width - 17 - 2 ? 0 : 17;
            }
            if (this.vsbSpace == 0 && this.hsbSpace != 0) {
                int n6 = this.vsbSpace = dimension.height <= this.height - 17 - 2 ? 0 : 17;
            }
            if (n2 != this.hsbSpace || n != this.vsbSpace) {
                bl = true;
            }
        }
        if (this.vsbSpace > 0) {
            n2 = this.height - 2 - this.hsbSpace;
            n = Math.max(dimension.height, n2);
            this.vsb.setValues(this.vsb.getValue(), n2, 0, n);
            this.vsb.setBlockIncrement((int)((double)this.vsb.getVisibleAmount() * 0.9));
            this.vsb.setSize(this.vsbSpace - 2, this.height - this.hsbSpace);
        }
        if (this.hsbSpace > 0) {
            n2 = this.width - 2 - this.vsbSpace;
            n = Math.max(dimension.width, n2);
            this.hsb.setValues(this.hsb.getValue(), n2, 0, n);
            this.hsb.setBlockIncrement((int)((double)this.hsb.getVisibleAmount() * 0.9));
            this.hsb.setSize(this.width - this.vsbSpace, this.hsbSpace - 2);
        }
        n2 = 0;
        Point point = new Point(0, 0);
        if (((ScrollPane)this.target).getComponentCount() > 0) {
            point = ((ScrollPane)this.target).getComponent(0).location();
            if (this.vsbSpace == 0 && point.y < 0) {
                point.y = 0;
                n2 = 1;
            }
            if (this.hsbSpace == 0 && point.x < 0) {
                point.x = 0;
                n2 = 1;
            }
        }
        if (n2 != 0) {
            this.scroll(this.x, this.y, 3);
        }
        return bl;
    }

    void setViewportSize() {
        this.clip.xSetBounds(1, 1, this.width - 2 - this.vsbSpace, this.height - 2 - this.hsbSpace);
    }

    public void setUnitIncrement(Adjustable adjustable, int n) {
        if (adjustable.getOrientation() == 1) {
            this.vsb.setUnitIncrement(n);
        } else {
            this.hsb.setUnitIncrement(n);
        }
    }

    public void setValue(Adjustable adjustable, int n) {
        if (adjustable.getOrientation() == 1) {
            this.scroll(-1, n, 1);
        } else {
            this.scroll(n, -1, 2);
        }
    }

    public void setScrollPosition(int n, int n2) {
        this.scroll(n, n2, 3);
    }

    void scroll(int n, int n2, int n3) {
        this.scroll(n, n2, n3, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scroll(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Component component;
        XScrollPanePeer.checkSecurity();
        ScrollPane scrollPane = (ScrollPane)this.target;
        if (scrollPane.countComponents() > 0) {
            component = scrollPane.getComponent(0);
            Color[] colorArray = this.getGUIcolors();
            if (scrollPane.getScrollbarDisplayPolicy() == 2) {
                n6 = -n;
                n5 = -n2;
            } else {
                Graphics graphics;
                ScrollPaneAdjustable scrollPaneAdjustable;
                Point point = component.location();
                n6 = point.x;
                n5 = point.y;
                if ((n3 & 2) != 0) {
                    this.hsb.setValue(Math.min(n, this.hsb.getMaximum() - this.hsb.getVisibleAmount()));
                    scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
                    this.setAdjustableValue(scrollPaneAdjustable, this.hsb.getValue(), n4);
                    n6 = -this.hsb.getValue();
                    graphics = this.getGraphics();
                    try {
                        this.paintHorScrollbar(graphics, colorArray, true);
                        Object var14_13 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        graphics.dispose();
                        throw throwable;
                    }
                }
                if ((n3 & 1) != 0) {
                    this.vsb.setValue(Math.min(n2, this.vsb.getMaximum() - this.vsb.getVisibleAmount()));
                    scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
                    this.setAdjustableValue(scrollPaneAdjustable, this.vsb.getValue(), n4);
                    n5 = -this.vsb.getValue();
                    graphics = this.getGraphics();
                    try {
                        this.paintVerScrollbar(graphics, colorArray, true);
                        Object var16_16 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        graphics.dispose();
                        throw throwable;
                    }
                }
            }
        } else {
            throw new NullPointerException("scrollpane child is null");
        }
        component.move(n6, n5);
    }

    void setAdjustableValue(ScrollPaneAdjustable scrollPaneAdjustable, int n, int n2) {
        AWTAccessor.getScrollPaneAdjustableAccessor().setTypedValue(scrollPaneAdjustable, n, n2);
    }

    public void paint(Graphics graphics) {
        this.paintComponent(graphics);
    }

    void paintScrollBars(Graphics graphics, Color[] colorArray) {
        if (this.vsbSpace > 0) {
            this.paintVerScrollbar(graphics, colorArray, true);
        }
        if (this.hsbSpace > 0) {
            this.paintHorScrollbar(graphics, colorArray, true);
        }
    }

    void repaintScrollBars() {
        Graphics graphics = this.getGraphics();
        Color[] colorArray = this.getGUIcolors();
        if (graphics != null) {
            this.paintScrollBars(graphics, colorArray);
        }
        graphics.dispose();
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.getGraphics();
        Color[] colorArray = this.getGUIcolors();
        if (graphics != null) {
            if (xScrollbar == this.vsb) {
                this.paintVerScrollbar(graphics, colorArray, true);
            } else if (xScrollbar == this.hsb) {
                this.paintHorScrollbar(graphics, colorArray, true);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Color[] colorArray = this.getGUIcolors();
        graphics.setColor(colorArray[0]);
        int n = this.height - this.hsbSpace;
        int n2 = this.width - this.vsbSpace;
        graphics.fillRect(0, 0, n2, n);
        graphics.fillRect(n2, n, this.vsbSpace, this.hsbSpace);
        this.draw3DRect(graphics, colorArray, 0, 0, n2 - 1, n - 1, false);
        this.paintScrollBars(graphics, colorArray);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        int n = aWTEvent.getID();
        switch (n) {
            case 800: 
            case 801: {
                this.repaintScrollBars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintHorScrollbar(Graphics graphics, Color[] colorArray, boolean bl) {
        if (this.hsbSpace <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        int n = this.width - this.vsbSpace - 2;
        graphics.fillRect(1, this.height - 17, n, 2);
        graphics.fillRect(0, this.height - 17, 1, 17);
        graphics.fillRect(1 + n, this.height - 17, 1, 17);
        try {
            graphics2.translate(1, this.height - 15);
            this.hsb.paint(graphics2, colorArray, bl);
            Object var7_6 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintVerScrollbar(Graphics graphics, Color[] colorArray, boolean bl) {
        if (this.vsbSpace <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics.setColor(colorArray[0]);
        int n = this.height - this.hsbSpace - 2;
        graphics.fillRect(this.width - 17, 1, 2, n);
        graphics.fillRect(this.width - 17, 0, 17, 1);
        graphics.fillRect(this.width - 17, 1 + n, 17, 1);
        try {
            graphics2.translate(this.width - 15, 1);
            this.vsb.paint(graphics2, colorArray, bl);
            Object var7_6 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n = mouseEvent.getModifiers();
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        if ((n & 0x10) == 0) {
            return;
        }
        switch (n2) {
            case 501: {
                if (this.inVerticalScrollbar(n3, n4)) {
                    this.active = 1;
                    int n5 = this.height - this.hsbSpace - 2;
                    this.vsb.handleMouseEvent(n2, n, n3 - (this.width - 17 + 2), n4 - 1);
                    break;
                }
                if (!this.inHorizontalScrollbar(n3, n4)) break;
                this.active = 2;
                int n6 = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(n2, n, n3 - 1, n4 - (this.height - 17 + 2));
                break;
            }
            case 502: {
                if (this.active == 1) {
                    this.vsb.handleMouseEvent(n2, n, n3, n4);
                    break;
                }
                if (this.active != 2) break;
                this.hsb.handleMouseEvent(n2, n, n3, n4);
                break;
            }
            case 506: {
                if (this.active == 1) {
                    int n7 = this.height - 2 - this.hsbSpace;
                    this.vsb.handleMouseEvent(n2, n, n3 - (this.width - 17 + 2), n4 - 1);
                    break;
                }
                if (this.active != 2) break;
                int n8 = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(n2, n, n3 - 1, n4 - (this.height - 17 + 2));
            }
        }
    }

    public void notifyValue(XScrollbar xScrollbar, int n, int n2, boolean bl) {
        if (xScrollbar == this.vsb) {
            this.scroll(-1, n2, 1, n);
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.scroll(n2, -1, 2, n);
        }
    }

    boolean inVerticalScrollbar(int n, int n2) {
        if (this.vsbSpace <= 0) {
            return false;
        }
        int n3 = this.height - 1 - this.hsbSpace;
        return n >= this.width - 15 && n < this.width && n2 >= 1 && n2 < n3;
    }

    boolean inHorizontalScrollbar(int n, int n2) {
        if (this.hsbSpace <= 0) {
            return false;
        }
        int n3 = this.width - 1 - this.vsbSpace;
        return n >= 1 && n < n3 && n2 >= this.height - 15 && n2 < this.height;
    }

    private Component getScrollChild() {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Component component = null;
        try {
            component = scrollPane.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Graphics graphics2;
        int n;
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.size();
        Color color = scrollPane.getBackground();
        Color color2 = scrollPane.getForeground();
        Point point = scrollPane.getScrollPosition();
        Component component = this.getScrollChild();
        Dimension dimension2 = component != null ? component.size() : new Dimension(0, 0);
        int n2 = scrollPane.getScrollbarDisplayPolicy();
        switch (n2) {
            case 2: {
                this.vsbSpace = 0;
                this.hsbSpace = 0;
                break;
            }
            case 1: {
                this.vsbSpace = 17;
                this.hsbSpace = 17;
                break;
            }
            case 0: {
                this.hsbSpace = dimension2.width <= dimension.width - 2 ? 0 : 17;
                int n3 = this.vsbSpace = dimension2.height <= dimension.height - 2 ? 0 : 17;
                if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                    int n4 = this.hsbSpace = dimension2.width <= dimension.width - 17 - 2 ? 0 : 17;
                }
                if (this.vsbSpace != 0 || this.hsbSpace == 0) break;
                this.vsbSpace = dimension2.height <= dimension.height - 17 - 2 ? 0 : 17;
            }
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (this.vsbSpace > 0) {
            n10 = 0;
            n12 = dimension.height - 2 - this.hsbSpace;
            n8 = Math.max(dimension2.height - n12, 0);
            n6 = point.y;
        }
        if (this.hsbSpace > 0) {
            n9 = 0;
            n11 = dimension.width - 2 - this.vsbSpace;
            n7 = Math.max(dimension2.width - n11, 0);
            n5 = point.x;
        }
        int n13 = dimension.width - this.vsbSpace;
        int n14 = dimension.height - this.hsbSpace;
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.hsbSpace > 0) {
            n = dimension.width - this.vsbSpace;
            graphics.fillRect(1, dimension.height - 17 - 3, n - 1, 14);
            graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 15);
                this.drawScrollbar(graphics2, color, 15, n, n9, n7, n5, n11, true);
                Object var23_22 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var23_23 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        if (this.vsbSpace > 0) {
            n = dimension.height - this.hsbSpace;
            graphics.fillRect(dimension.width - 17 - 3, 1, 14, n - 1);
            graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 15, 0);
                this.drawScrollbar(graphics2, color, 15, n, n10, n8, n6, n12, false);
                Object var25_25 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var25_26 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n13 - 1, n14 - 1, false);
        this.target.print(graphics);
        scrollPane.printComponents(graphics);
    }

    static class XScrollPaneContentWindow
    extends XWindow {
        XScrollPaneContentWindow(ScrollPane scrollPane, long l) {
            super(scrollPane, l);
        }

        public String getWMName() {
            return "ScrollPane content";
        }
    }
}

