/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final Map<Set<String>, ClassLoader> map;

    ClassLoaderObjectInputStream(InputStream inputStream, Map<Set<String>, ClassLoader> map) throws IOException {
        super(inputStream);
        if (map == null) {
            throw new NullPointerException("Null map");
        }
        this.map = map;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(string);
        ClassLoader classLoader = this.map.get(hashSet);
        if (classLoader != null) {
            return Class.forName(string, false, classLoader);
        }
        return super.resolveClass(objectStreamClass);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        ClassLoader classLoader = this.map.get(hashSet);
        if (classLoader == null) {
            return super.resolveProxyClass(stringArray);
        }
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }
}

