/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JsseJce;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.util.KeyUtil;

final class DHCrypt {
    private BigInteger modulus;
    private BigInteger base;
    private PrivateKey privateKey;
    private BigInteger publicValue;
    private static int MAX_FAILOVER_TIMES = 2;

    DHCrypt(int n, SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
            keyPairGenerator.initialize(n, secureRandom);
            DHPublicKeySpec dHPublicKeySpec = this.generateDHPublicKeySpec(keyPairGenerator);
            if (dHPublicKeySpec == null) {
                throw new RuntimeException("Could not generate DH keypair");
            }
            this.publicValue = dHPublicKeySpec.getY();
            this.modulus = dHPublicKeySpec.getP();
            this.base = dHPublicKeySpec.getG();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    DHCrypt(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        this.modulus = bigInteger;
        this.base = bigInteger2;
        try {
            KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
            DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2);
            keyPairGenerator.initialize(dHParameterSpec, secureRandom);
            DHPublicKeySpec dHPublicKeySpec = this.generateDHPublicKeySpec(keyPairGenerator);
            if (dHPublicKeySpec == null) {
                throw new RuntimeException("Could not generate DH keypair");
            }
            this.publicValue = dHPublicKeySpec.getY();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
        }
    }

    static DHPublicKeySpec getDHPublicKeySpec(PublicKey publicKey) {
        if (publicKey instanceof DHPublicKey) {
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
        }
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DH");
            return keyFactory.getKeySpec(publicKey, DHPublicKeySpec.class);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    BigInteger getModulus() {
        return this.modulus;
    }

    BigInteger getBase() {
        return this.base;
    }

    BigInteger getPublicKey() {
        return this.publicValue;
    }

    SecretKey getAgreedSecret(BigInteger bigInteger, boolean bl) throws IOException {
        try {
            KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, this.modulus, this.base);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            KeyAgreement keyAgreement = JsseJce.getKeyAgreement("DiffieHellman");
            if (!bl && !KeyUtil.isOracleJCEProvider(keyAgreement.getProvider().getName())) {
                try {
                    KeyUtil.validate(dHPublicKeySpec);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new SSLHandshakeException(invalidKeyException.getMessage());
                }
            }
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret("TlsPremasterSecret");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Could not generate secret", generalSecurityException);
        }
    }

    private DHPublicKeySpec generateDHPublicKeySpec(KeyPairGenerator keyPairGenerator) throws GeneralSecurityException {
        boolean bl = !KeyUtil.isOracleJCEProvider(keyPairGenerator.getProvider().getName());
        for (int i = 0; i <= MAX_FAILOVER_TIMES; ++i) {
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            DHPublicKeySpec dHPublicKeySpec = DHCrypt.getDHPublicKeySpec(keyPair.getPublic());
            if (bl) {
                try {
                    KeyUtil.validate(dHPublicKeySpec);
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (i != MAX_FAILOVER_TIMES) continue;
                    throw invalidKeyException;
                }
            }
            return dHPublicKeySpec;
        }
        return null;
    }
}

