/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.jnl.JARUpdater;
import com.sun.javaws.jnl.ResourceType;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;

public class JARDesc
implements ResourceType {
    private URL _location;
    private String _locationString;
    private String _version;
    private int _size;
    private boolean _isNativeLib;
    private boolean _isLazyDownload;
    private boolean _isProgressDownload;
    private boolean _isMainFile;
    private String _part;
    private ResourcesDesc _parent;
    private JARUpdater _updater = null;
    private boolean _pack200Enabled = false;
    private boolean _versionEnabled = false;
    private static final boolean isConfigValid = Config.isConfigValid();

    public JARDesc(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, String string2, int n, ResourcesDesc resourcesDesc) {
        this(uRL, string, bl, bl2, bl3, string2, n, resourcesDesc, false);
    }

    public JARDesc(URL uRL, String string, boolean bl, boolean bl2, boolean bl3, String string2, int n, ResourcesDesc resourcesDesc, boolean bl4) {
        this._location = uRL;
        this._locationString = uRL != null ? uRL.toString() : null;
        this._version = string;
        this._isLazyDownload = bl && !this._isMainFile;
        this._isNativeLib = bl3;
        this._isMainFile = bl2;
        this._part = string2;
        this._size = n;
        this._parent = resourcesDesc;
        this._isProgressDownload = bl4;
    }

    public void setPack200Enabled() {
        this._pack200Enabled = true;
    }

    public void setVersionEnabled() {
        this._versionEnabled = true;
    }

    public boolean isPack200Enabled() {
        if (Config.isJavaVersionAtLeast15()) {
            return this._pack200Enabled;
        }
        return false;
    }

    public boolean isVersionEnabled() {
        return this._versionEnabled;
    }

    public boolean isNativeLib() {
        return this._isNativeLib;
    }

    public boolean isJavaFile() {
        return !this._isNativeLib;
    }

    public boolean isProgressJar() {
        return this._isProgressDownload;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isLazyDownload() {
        return this._isLazyDownload;
    }

    public void setLazyDownload(boolean bl) {
        this._isLazyDownload = bl;
    }

    public boolean isMainJarFile() {
        return this._isMainFile;
    }

    public String getPartName() {
        return this._part;
    }

    public int getSize() {
        return this._size;
    }

    public ResourcesDesc getParent() {
        return this._parent;
    }

    public void visit(ResourceVisitor resourceVisitor) {
        resourceVisitor.visitJARDesc(this);
    }

    public synchronized JARUpdater getUpdater() {
        if (this._updater == null) {
            this._updater = new JARUpdater(this);
        }
        return this._updater;
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("href", this._location);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("part", this._part);
        xMLAttributeBuilder.add("download", this.isProgressJar() ? "progress" : (this.isLazyDownload() ? "lazy" : "eager"));
        xMLAttributeBuilder.add("main", this.isMainJarFile() ? "true" : "false");
        String string = this._isNativeLib ? "nativelib" : "jar";
        return new XMLNode(string, xMLAttributeBuilder.getAttributeList());
    }

    public String toString() {
        return "JARDesc[" + this._locationString + ":" + this._version + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof JARDesc)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JARDesc jARDesc = (JARDesc)object;
        if (this.getVersion() != null) {
            return this.getVersion().equals(jARDesc.getVersion()) && this._locationString.equals(jARDesc._locationString);
        }
        return jARDesc.getVersion() == null && this._locationString.equals(jARDesc._locationString);
    }

    public int hashCode() {
        int n = 0;
        if (this.getVersion() != null) {
            n = this.getVersion().hashCode();
        }
        if (this._locationString != null) {
            n ^= this._locationString.hashCode();
        }
        return n;
    }
}

