/*
 * Decompiled with CFR 0.152.
 */
package productinstaller;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import productinstaller.ChooseDirPanel;
import productinstaller.ChooseInstallOptionsPanel;
import productinstaller.IPanelAction;
import productinstaller.InstallingPanel;
import productinstaller.LicensePanel;
import productinstaller.ListObject;
import productinstaller.XmlPrefs;

public class ProductInstaller
extends JFrame {
    Document doc;
    XmlPrefs xmlPrefs;
    public static ProductInstaller mainLink;
    private JPanel headerPanel;
    private JPanel chooseInstallOptionsPanel;
    private JPanel chooseDirPanel;
    private JPanel licensePanel;
    private JPanel installingPanel;
    private JPanel centralPanel;
    private JPanel bottomPanel;
    public static ArrayList<JPanel> panelsList;
    private JLabel headerLabel;
    private JButton closeButt;
    private JButton nextButt;
    private int x;
    private int y;
    private int counter = 1;
    private String BUILD;
    public static String PATH;
    public static String OS;
    public static String SEP;

    public ProductInstaller() throws HeadlessException {
        super("Product Installer");
        this.setDefaultCloseOperation(3);
        mainLink = this;
        this.xmlPrefs = new XmlPrefs(this.doc, this);
        UIManager.put("OptionPane.okButtonText", "OK");
        UIManager.put("OptionPane.yesButtonText", "\u0414\u0410");
        UIManager.put("OptionPane.noButtonText", "\u041d\u0415\u0422");
        UIManager.put("OptionPane.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.acceptAllFileFilterText", "\u0412\u0441\u0435 \u0444\u0430\u0439\u043b\u044b");
        UIManager.put("FileChooser.lookInLabelText", "\u0421\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432");
        UIManager.put("FileChooser.saveInLabelText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432");
        UIManager.put("FileChooser.cancelButtonText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.cancelButtonToolTipText", "\u041e\u0442\u043c\u0435\u043d\u0430");
        UIManager.put("FileChooser.openButtonText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        UIManager.put("FileChooser.openButtonToolTipText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b");
        UIManager.put("FileChooser.saveButtonText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        UIManager.put("FileChooser.saveButtonToolTipText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0444\u0430\u0439\u043b");
        UIManager.put("FileChooser.filesOfTypeLabelText", "\u0422\u0438\u043f:");
        UIManager.put("FileChooser.fileNameLabelText", "\u0424\u0430\u0439\u043b(\u044b):");
        UIManager.put("FileChooser.listViewButtonToolTipText", "\u0421\u043f\u0438\u0441\u043e\u043a");
        UIManager.put("FileChooser.listViewButtonAccessibleName", "\u0421\u043f\u0438\u0441\u043e\u043a");
        UIManager.put("FileChooser.homeFolderToolTipText", "\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b");
        UIManager.put("FileChooser.homeFolderAccessibleName", "\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b");
        UIManager.put("FileChooser.newFolderToolTipText", "\u041d\u043e\u0432\u0430\u044f \u043f\u0430\u043f\u043a\u0430");
        UIManager.put("FileChooser.detailsViewButtonToolTipText", "\u0422\u0430\u0431\u043b\u0438\u0446\u0430");
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", "\u0422\u0430\u0431\u043b\u0438\u0446\u0430");
        UIManager.put("FileChooser.upFolderToolTipText", "\u041d\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u044b\u0448\u0435");
        UIManager.put("FileChooser.upFolderAccessibleName", "\u041d\u0430 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0432\u044b\u0448\u0435");
        UIManager.put("FileChooser.openDialogTitleText", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        UIManager.put("FileChooser.saveDialogTitleText", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        ResourceBundle rb = ResourceBundle.getBundle("version");
        this.BUILD = rb.getString("BUILD");
        String classPath = System.getProperty("java.class.path");
        PATH = classPath.substring(0, classPath.lastIndexOf(System.getProperty("file.separator", File.separator)) + 1);
        OS = this.getOsType();
        SEP = System.getProperty("file.separator", File.separator);
        System.out.println("PATH: " + PATH);
        this.chooseInstallOptionsPanel = new ChooseInstallOptionsPanel(this);
        this.chooseDirPanel = new ChooseDirPanel(this);
        this.licensePanel = new LicensePanel(this);
        this.installingPanel = new InstallingPanel(this);
        panelsList.add(this.chooseInstallOptionsPanel);
        panelsList.add(this.chooseDirPanel);
        panelsList.add(this.installingPanel);
        this.initGUI();
        this.setVisible(true);
        this.toFront();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ProductInstaller();
            }
        });
    }

    private void initGUI() {
        this.setSize(this.xmlPrefs.getInt("width"), this.xmlPrefs.getInt("height"));
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        int sh = toolKit.getScreenSize().height;
        int sw = toolKit.getScreenSize().width;
        this.setLocation(sw / 2 - this.getWidth() / 2, sh / 2 - this.getHeight() / 2);
        this.setUndecorated(true);
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 0));
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.headerPanel.setBackground(new Color(53, 109, 154));
        this.headerLabel = new JLabel(this.xmlPrefs.getStr("title"));
        this.headerLabel.setForeground(Color.white);
        this.headerPanel.add(this.headerLabel);
        this.headerPanel.add(Box.createHorizontalGlue());
        this.closeButt = new JButton("X");
        this.closeButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.headerPanel.add(this.closeButt);
        this.headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ProductInstaller.this.x = e.getX();
                ProductInstaller.this.y = e.getY();
            }
        });
        this.headerPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ProductInstaller.this.setLocation(evt.getXOnScreen() - ProductInstaller.this.x, evt.getYOnScreen() - ProductInstaller.this.y);
            }
        });
        this.add((Component)this.headerPanel, "North");
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.nextButt = new JButton("\u0434\u0430\u043b\u0435\u0435");
        this.nextButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProductInstaller.this.counter + 1 <= panelsList.size()) {
                    ProductInstaller.this.centralPanel.removeAll();
                    IPanelAction panel = (IPanelAction)((Object)panelsList.get(ProductInstaller.this.counter));
                    ProductInstaller.this.centralPanel.add(panelsList.get(ProductInstaller.this.counter));
                    ProductInstaller.this.validate();
                    ProductInstaller.this.repaint();
                    ProductInstaller.this.counter += panel.PanelAction();
                } else {
                    System.exit(0);
                }
            }
        });
        this.bottomPanel.add(this.nextButt);
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(new GridLayout(1, 1));
        this.centralPanel.add(panelsList.get(0));
        this.add((Component)this.centralPanel, "Center");
    }

    public ArrayList<ListObject> getSelectedOptions() {
        ArrayList<ListObject> selectedOptions = new ArrayList<ListObject>();
        Vector<ListObject> discs = ((ChooseInstallOptionsPanel)this.chooseInstallOptionsPanel).discs;
        for (int i = 0; i < discs.size(); ++i) {
            if (!discs.get(i).isBoxChecked()) continue;
            selectedOptions.add(discs.get(i));
        }
        return selectedOptions;
    }

    public String getInstallPath() {
        return ((ChooseDirPanel)this.chooseDirPanel).textField.getText();
    }

    public void toggleNextButton(boolean toggle) {
        this.nextButt.setEnabled(toggle);
    }

    public void setNextButtonLabel(String label) {
        this.nextButt.setText(label);
    }

    public void toggleCloseButton(boolean toggle) {
        this.closeButt.setEnabled(toggle);
    }

    public String getOsType() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            return "win";
        }
        if (OS.indexOf("mac") >= 0) {
            return "mac";
        }
        if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) {
            return "nix";
        }
        if (OS.indexOf("sunos") >= 0) {
            return "sol";
        }
        return "";
    }

    static {
        panelsList = new ArrayList();
    }
}

