/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReverseBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    private Date date;
    private X509CertSelector targetCertSelector;
    Set<String> initPolicies;

    ReverseBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal) {
        super(pKIXBuilderParameters, x500Principal);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.targetCertSelector = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
        Set<String> set = pKIXBuilderParameters.getInitialPolicies();
        this.initPolicies = new HashSet<String>();
        if (set.isEmpty()) {
            this.initPolicies.add("2.5.29.32.0");
        } else {
            for (String string : set) {
                this.initPolicies.add(string);
            }
        }
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State state, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        ReverseState reverseState = (ReverseState)state;
        if (this.debug != null) {
            this.debug.println("In ReverseBuilder.getMatchingCerts.");
        }
        Collection<X509Certificate> collection = this.getMatchingEECerts(reverseState, list);
        collection.addAll(this.getMatchingCACerts(reverseState, list));
        return collection;
    }

    private Collection<X509Certificate> getMatchingEECerts(ReverseState reverseState, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        X509CertSelector x509CertSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        CertPathHelper.setIssuer(x509CertSelector, reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(-2);
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        this.addMatchingCerts(x509CertSelector, list, hashSet, true);
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingEECerts got " + hashSet.size() + " certs.");
        }
        return hashSet;
    }

    private Collection<X509Certificate> getMatchingCACerts(ReverseState reverseState, List<CertStore> list) throws CertificateException, CertStoreException, IOException {
        X509CertSelector x509CertSelector = new X509CertSelector();
        CertPathHelper.setIssuer(x509CertSelector, reverseState.subjectDN);
        x509CertSelector.setCertificateValid(this.date);
        x509CertSelector.addPathToName(4, this.targetCertSelector.getSubjectAsBytes());
        if (reverseState.explicitPolicy == 0) {
            x509CertSelector.setPolicy(this.getMatchingPolicies());
        }
        x509CertSelector.setBasicConstraints(0);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        this.addMatchingCerts(x509CertSelector, list, arrayList, true);
        Collections.sort(arrayList, new PKIXCertComparator());
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.getMatchingCACerts got " + arrayList.size() + " certs.");
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void verifyCert(X509Certificate x509Certificate, State state, List<X509Certificate> list) throws GeneralSecurityException {
        void var8_16;
        boolean bl;
        ReverseState reverseState;
        if (this.debug != null) {
            this.debug.println("ReverseBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        if ((reverseState = (ReverseState)state).isInitial()) {
            return;
        }
        reverseState.untrustedChecker.check(x509Certificate, Collections.<String>emptySet());
        AlgorithmChecker.check(x509Certificate);
        if (list != null && !list.isEmpty()) {
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            for (X509Certificate object2 : list) {
                arrayList.add(0, object2);
            }
            bl = false;
            for (X509Certificate x509Certificate2 : arrayList) {
                X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate2);
                PolicyMappingsExtension policyMappingsExtension = x509CertImpl.getPolicyMappingsExtension();
                if (policyMappingsExtension != null) {
                    bl = true;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + bl);
                }
                if (!x509Certificate.equals(x509Certificate2) || !this.buildParams.isPolicyMappingInhibited() && bl) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        boolean bl2 = x509Certificate.getSubjectX500Principal().equals(this.targetSubjectDN);
        boolean bl3 = bl = x509Certificate.getBasicConstraints() != -1;
        if (!bl2) {
            if (!bl) {
                throw new CertPathValidatorException("cert is NOT a CA cert");
            }
            if (reverseState.remainingCACerts <= 0 && !X509CertImpl.isSelfIssued(x509Certificate)) {
                throw new CertPathValidatorException("pathLenConstraint violated, path too long");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        } else if (!this.targetCertSelector.match(x509Certificate)) {
            throw new CertPathValidatorException("target certificate constraints check failed");
        }
        if (this.buildParams.isRevocationEnabled()) {
            reverseState.crlChecker.check(x509Certificate, reverseState.pubKey, reverseState.crlSign);
        }
        if ((bl2 || !X509CertImpl.isSelfIssued(x509Certificate)) && reverseState.nc != null) {
            try {
                if (!reverseState.nc.verify(x509Certificate)) {
                    throw new CertPathValidatorException("name constraints check failed");
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException(iOException);
            }
        }
        X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
        reverseState.rootNode = PolicyChecker.processPolicies(reverseState.certIndex, this.initPolicies, reverseState.explicitPolicy, reverseState.policyMapping, reverseState.inhibitAnyPolicy, this.buildParams.getPolicyQualifiersRejected(), reverseState.rootNode, x509CertImpl, bl2);
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            Set set2 = Collections.emptySet();
        }
        for (PKIXCertPathChecker pKIXCertPathChecker : reverseState.userCheckers) {
            pKIXCertPathChecker.check(x509Certificate, (Collection<String>)var8_16);
        }
        if (!var8_16.isEmpty()) {
            var8_16.remove(PKIXExtensions.BasicConstraints_Id.toString());
            var8_16.remove(PKIXExtensions.NameConstraints_Id.toString());
            var8_16.remove(PKIXExtensions.CertificatePolicies_Id.toString());
            var8_16.remove(PKIXExtensions.PolicyMappings_Id.toString());
            var8_16.remove(PKIXExtensions.PolicyConstraints_Id.toString());
            var8_16.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
            var8_16.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
            var8_16.remove(PKIXExtensions.KeyUsage_Id.toString());
            var8_16.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
            if (!var8_16.isEmpty()) {
                throw new CertificateException("Unrecognized critical extension(s)");
            }
        }
        if (this.buildParams.getSigProvider() != null) {
            x509Certificate.verify(reverseState.pubKey, this.buildParams.getSigProvider());
        } else {
            x509Certificate.verify(reverseState.pubKey);
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectX500Principal().equals(this.targetSubjectDN);
    }

    @Override
    void addCertToPath(X509Certificate x509Certificate, LinkedList<X509Certificate> linkedList) {
        linkedList.addLast(x509Certificate);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> linkedList) {
        linkedList.removeLast();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PKIXCertComparator
    implements Comparator<X509Certificate> {
        private Debug debug = Debug.getInstance("certpath");

        PKIXCertComparator() {
        }

        @Override
        public int compare(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            int n;
            int n2;
            if (x509Certificate.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return -1;
            }
            if (x509Certificate2.getSubjectX500Principal().equals(ReverseBuilder.this.targetSubjectDN)) {
                return 1;
            }
            try {
                X500Name x500Name = X500Name.asX500Name(ReverseBuilder.this.targetSubjectDN);
                n2 = Builder.targetDistance(null, x509Certificate, x500Name);
                n = Builder.targetDistance(null, x509Certificate2, x500Name);
            }
            catch (IOException iOException) {
                if (this.debug != null) {
                    this.debug.println("IOException in call to Builder.targetDistance");
                    iOException.printStackTrace();
                }
                throw new ClassCastException("Invalid target subject distinguished name");
            }
            if (n2 == n) {
                return 0;
            }
            if (n2 == -1) {
                return 1;
            }
            if (n2 < n) {
                return -1;
            }
            return 1;
        }
    }
}

