/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public abstract class HttpsURLConnection
extends HttpURLConnection {
    private static HostnameVerifier defaultHostnameVerifier;
    protected HostnameVerifier hostnameVerifier = defaultHostnameVerifier;
    private static SSLSocketFactory defaultSSLSocketFactory;
    private SSLSocketFactory sslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();

    protected HttpsURLConnection(URL uRL) {
        super(uRL);
    }

    public abstract String getCipherSuite();

    public abstract Certificate[] getLocalCertificates();

    public abstract Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Certificate[] certificateArray = this.getServerCertificates();
        return ((X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    public Principal getLocalPrincipal() {
        Certificate[] certificateArray = this.getLocalCertificates();
        if (certificateArray != null) {
            return ((X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }
        return null;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("no default HostnameVerifier specified");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("setHostnameVerifier"));
        }
        defaultHostnameVerifier = hostnameVerifier;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("no HostnameVerifier specified");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("no default SSLSocketFactory specified");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        defaultSSLSocketFactory = sSLSocketFactory;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return defaultSSLSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("no SSLSocketFactory specified");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        this.sslSocketFactory = sSLSocketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    static {
        try {
            defaultHostnameVerifier = new sun.net.www.protocol.https.DefaultHostnameVerifier();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            defaultHostnameVerifier = new DefaultHostnameVerifier();
        }
        defaultSSLSocketFactory = null;
    }

    private static class DefaultHostnameVerifier
    implements HostnameVerifier {
        private DefaultHostnameVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return false;
        }
    }
}

